local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local SetScriptValue = require "bluecore.base.set_script_value"
local SetScriptFilePath = SetScriptValue:extend();


---- 游戏运行模式
function SetScriptFilePath:new(...)
  SetScriptFilePath.super.new(self, ...)

end

function SetScriptFilePath:_OnUpdate(args)

  local scriptIns = args[1];
  local para = args[2];
  --scriptIns[para] = args[3];
  scriptIns:SetScriptValue(para, args[3]);
end



function SetScriptFilePath:_IsRightType(key, value, scriptIns)
  local typeInfo = scriptIns:GetTypeInfomation(key);
  --防止lua对象传到C++去
  return type(value) ~= "userdata" and typeInfo:isType(Types.FilePathType);
end



SetScriptFilePath:RegisterInput(1, Types.ScriptInsRefType, "Script_Instance", "behaviour", Types.NotNullType());
SetScriptFilePath:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING);
SetScriptFilePath:RegisterInput(3, Types.FilePathType, "ParaValue", "参数值", "comm:documents/texture/material/blank.jpg");


SetScriptFilePath:RegisterExecInput(1, "exec", "执行");

SetScriptFilePath:RegisterExecOutput(1, "exec", "执行");

SetScriptFilePath:SetFunctionName("SetScriptFilePath");


return SetScriptFilePath ;

