local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local GetScriptValue = require "bluecore.base.get_script_value"
local GetScriptColor = GetScriptValue:extend();


---- 游戏运行模式
function GetScriptColor:new(...)
  GetScriptColor.super.new(self, ...)

end

function GetScriptColor:_OnUpdate(args)

  local scriptIns = args[1];
  local para = args[2];
  --scriptIns[para] = args[3];
  return scriptIns:GetScriptValue(para);
end



function GetScriptColor:_IsRightType(key, value, scriptIns)
  return type(value) == "userdata" and value:RTTI() == mathfunction.Color:RTTI();
end



GetScriptColor:RegisterInput(1, Types.ScriptInsRefType, "Script_Instance", "behaviour", Types.NotNullType());
GetScriptColor:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING);

GetScriptColor:RegisterOutput(1, mathfunction.Color:RTTI(), "Color", "获取参数值");


GetScriptColor:SetFunctionName("GetScriptColor");


return GetScriptColor ;

