local mf = require "mathfunction"
local BU = require "bluecore.blueutility"
local BlueNode = require "bluecore.bluenode"

local Types = require "venuscore.rtti.types"

local BreakIris = BlueNode:extend();

---- 游戏运行模式
function BreakIris:new(...)
  BreakIris.super.new(self, ...)
end

function BreakIris:_OnUpdate(args)
  local structIris = args[1];
  if structIris == nil then
    return mf.vector2(0,0), mf.vector2(0,0), {}, {}
  else
    return
          structIris.leftEyeCenter ~= nil and structIris.leftEyeCenter or mf.vector2(0,0),
          structIris.rightEyeCenter ~= nil and structIris.rightEyeCenter or mf.vector2(0,0),
          structIris.leftEyeLankmark ~= nil and structIris.leftEyeLankmark or {},
          structIris.rightEyeLankmark ~= nil and structIris.rightEyeLankmark or {}
  end
end


---- 编辑器模式
BreakIris:RegisterInput(1, Types.IrisType, "Iris", "瞳孔点", nil);
BreakIris:RegisterOutput(1, mf.vector2:RTTI(), "leftEyeCenter", "左眼中心");
BreakIris:RegisterOutput(2, mf.vector2:RTTI(), "rightEyeCenter", "右眼中心");
BreakIris:RegisterOutput(3, BU:GetArrayRtti(mf.vector2:RTTI()), "leftLandmark", "左眼关键点(数组,20个)");
BreakIris:RegisterOutput(4, BU:GetArrayRtti(mf.vector2:RTTI()), "rightLandmark", "右眼关键点(数组,20个)");

BreakIris:SetFunctionName("BreakIris");


return BreakIris;

