
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BD = require "bluecore.bluedefined"

local GetAttachedFbo = BlueNode:extend();

---- 游戏运行模式
function GetAttachedFbo:new(...)
  GetAttachedFbo.super.new(self,...);
end

function GetAttachedFbo:_OnUpdate(args)
  local attachedFbo = args[1]:GetAttachedRenderTarget();
  if not attachedFbo then
    return nil,nil;
  else
    return attachedFbo, attachedFbo:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  end
end


---- 编辑器模式

GetAttachedFbo:RegisterInput(1, apolloengine.CameraComponent:RTTI(), "target", "相机组件", BlueSelf());

GetAttachedFbo:RegisterOutput(1, apolloengine.RenderTargetEntity:RTTI(), "FBO", "相机渲染的FBO");
GetAttachedFbo:RegisterOutput(2, apolloengine.TextureEntity:RTTI(), "tex", "fbo绑定的纹理");



GetAttachedFbo:SetFunctionName("GetAttachedFbo");
GetAttachedFbo:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return GetAttachedFbo ;