local AE = require "apolloengine"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local ResetAll = BlueNode:extend();

function ResetAll:new(...)
  ResetAll.super.new(self, ...);
end


function ResetAll:_OnUpdate(args)
  args[1]:ResetAll(args[2]);
end

ResetAll:RegisterInput(1, AE.AnimationComponent:RTTI(), "target", "动画组件", BlueSelf());
ResetAll:RegisterInput(2, Types.BoolType, "toZero", "重置到曲线开头", true);

ResetAll:RegisterExecInput(1, "exec", "Execute");
ResetAll:RegisterExecOutput(1, "exec", "Execute");

ResetAll:SetFunctionName("AniReset");

return ResetAll;
