local libvenuscore = require "libvenuscore"
--! do NOT import any other lua file here !
-- this file will load, no matter blueprintComp is used or not
local bluedeserializaion = {}
local Deserialization
local BluePrintVariable
local BlueFunctionInfo
local Blueprint
local BlueScene
local BD
local BlueprintTypeName
local BlueSceneTypeName

--  lazy import blue*.lua, just before deserialize create BlueprintComp/Blueprint/BlueFunction/BlueFtnLIb
local function LazyInitialization()

  WARNING("LazyInitialization Blue Component");

  -- add Types.Blue* register here
  -- local Types = require "venuscore.rtti.types"
  -- Types.BlueTextureEntity = ....

  BluePrintVariable = require "bluecore.bluevariableinfo"
  BlueFunctionInfo =  require "bluecore.bluefuncpininfo"
  Deserialization = require "venuscore.bundle.serialization.deserialization"


  Blueprint = require "bluecore.blueprint"
  BlueScene = require "bluecore.core.blue_scene"
  BD = require "bluecore.bluedefined"

  -- 蓝图中不需要反序列化特殊处理,但会序列化的(并且extend有名字的) 需要在这里注册到RttiManager
  require "bluecore.core.array_item_wrap"
  require "bluecore.core.blueprint_self"

  BlueprintTypeName = Blueprint:GetTypeName()
  BlueSceneTypeName = BlueScene:GetTypeName()

  LazyInitialization = function()  end -- replace empty

end


bluedeserializaion.BlueCompDeserializeInit = function(host, typename, path)

  LazyInitialization();

  if _KRATOSEDITOR then
    if path ~= BD.LuaPath
      and path ~= BD.ScenePath then
      local startIdx, endIdx = string.find(typename, "]$");
      if startIdx ~= nil then
        WARNING("BlueCompDeserializeInit typename not found "..tostring(typename));
        return {}
      else
        error("BlueCompDeserializeInit path error:"
          ..tostring(typename)
          ..tostring(path) );
      end

    end
  end
  local instance
  if typename == BlueprintTypeName then
    instance = Blueprint();
  elseif typename == BlueSceneTypeName then
    instance = BlueScene();
  else
    WARNING("BlueCompDeserializeInit typename not found "..tostring(typename));
  end
  --because bluefunction is derived from blueprint, we all use require
  --local instance = venuscore.LoadBehavior(path);
  return instance;
end

bluedeserializaion.onBlueNode = function(attributes, host, cls, key, nodes, referenceinfo)
  local dataType = attributes["__typename"];
  if cls == nil then
  -- 反序列化创建BlueNode实例
  -- 通过序列化信息中的attributes中的luaPath 加载文件
  local blueprint = referenceinfo.blueprint; -- host.blueprint
  cls = bluedeserializaion._InstantiationBlueNode(dataType, blueprint, key, attributes);
  --LOG("cls " ..tostring(cls))
  end
  local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
  cls = Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
  if cls._OnDeserialize then
  cls:_OnDeserialize()
  end
  return cls
end


bluedeserializaion.onBlueVariableInfo = function (attributes, host, cls, key, nodes, referenceinfo)

  local dataType = attributes["__typename"];
  if cls == nil then
    -- 反序列化创建BlueNode实例
    -- 通过序列化信息中的attributes中的luaPath 加载文件
    local blueprint = referenceinfo.blueprint
    cls = bluedeserializaion._InstantiationBlueVariableInfo(dataType, attributes, blueprint);
  end
  local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
  cls = Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
  if cls._OnDeserialize then
    cls:_OnDeserialize()
  end
  return cls
end

bluedeserializaion.onBlueFunctionInfo = function (attributes, host, cls, key, nodes, referenceinfo)

  local dataType = attributes["__typename"];
  if cls == nil then
    -- 反序列化创建BlueNode实例
    -- 通过序列化信息中的attributes中的luaPath 加载文件
    local blueprint = referenceinfo.blueprint
    cls = bluedeserializaion._InstantiationBlueFuncInfo(dataType, attributes, blueprint);
  end
  local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
  cls = Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
  if cls._OnDeserialize then
    cls:_OnDeserialize()
  end
  return cls
end

bluedeserializaion.onBlueFtnLib = function(attributes, host, cls, key, nodes, referenceinfo)

  LazyInitialization();

  local dataType = attributes["__typename"];
  if cls == nil then
    local BlueFtnLIb = require "bluecore.core.blue_ftn_lib"
    cls = BlueFtnLIb();
  end

  local origin = referenceinfo.blueprint
  referenceinfo.blueprint = nil; -- 换成nil 因为全局bluefunction不应传入blueprint
  local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
  cls = Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
  if cls._OnDeserialize then
    cls:_OnDeserialize()
  end
  referenceinfo.blueprint = origin
  return cls;
end

bluedeserializaion.onBlueFunction = function(attributes, host, cls, key, nodes, referenceinfo)

  LazyInitialization();
  
  local dataType = attributes["__typename"];
  if cls == nil then
    local BlueFunction = require "bluecore.bluefunction"
    cls = BlueFunction(referenceinfo.blueprint, nil, nil); -- 如果是nil 就是来自blueFtnLib 全局函数
  end
  local origin = referenceinfo.blueprint
  referenceinfo.blueprint = cls;
  local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
  cls = Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
  if cls._OnDeserialize then
    cls:_OnDeserialize()
  end
  referenceinfo.blueprint = origin
  return cls
end

bluedeserializaion.onBlueScene = function(attributes, host, cls, key, nodes, referenceinfo)

  LazyInitialization();

  local dataType = attributes["__typename"];
  if cls == nil then
    cls = Deserialization:_InstantiationCls(dataType, host, key);
  end
  -- 因为反序列化BlueNode需要依赖BluePrint参与(目前是模板节点)
  --host.blueprint = cls; -- not ok
  local origin = referenceinfo.blueprint
  referenceinfo.blueprint = cls;
  -- host 不能换成blueprint因为Load需要参数host
  local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
  cls = Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
  if cls._OnDeserialize then
    cls:_OnDeserialize()
  end
  referenceinfo.blueprint = origin
  return cls;

end


bluedeserializaion.onBlueEventDispatcher = function(attributes, host, cls, key, nodes, referenceinfo)

  local dataType = attributes["__typename"];
  if cls == nil then
    local BlueEventDispatcher = require "bluecore.core.blue_event_dispatcher"
    cls = BlueEventDispatcher(referenceinfo.blueprint);
  end

  local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
  cls = Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
  if cls._OnDeserialize then
    cls:_OnDeserialize()
  end
  return cls
end


bluedeserializaion.onBluePrint = function(attributes, host, cls, key, nodes, referenceinfo)

  LazyInitialization();

  local dataType = attributes["__typename"];
  if cls == nil then
    cls = Deserialization:_InstantiationCls(dataType, host, key);
  end

  if attributes.bluePrintLinkList ~= nil and attributes._version == nil then
    attributes.bluePrintLinkList.__typename = nil
    for _, link in pairs(attributes.bluePrintLinkList) do
      link[BD.LINK_START] = link["startPinUid"]
      link[BD.LINK_END] = link["endPinUid"]
      link[BD.LINK_UID] = link["uid"]
      link["startPinUid"] = nil
      link["endPinUid"] = nil
      link["uid"] = nil
    end
    attributes.bluePrintLinkList.__typename = "table"
    attributes._version = BD.VERSION -- for blueMenu Run-Stop
  end

  -- 因为反序列化BlueNode需要依赖BluePrint参与(目前是模板节点)
  --host.blueprint = cls; -- not ok
  local origin = referenceinfo.blueprint
  referenceinfo.blueprint = cls;
  -- host 不能换成blueprint因为Load需要参数host
  local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
  cls = Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
  if cls._OnDeserialize then
    cls:_OnDeserialize()
  end
  referenceinfo.blueprint = origin
  return cls;
end

bluedeserializaion.OnBlueNil = function(attributes, host, cls, key, nodes, referenceinfo)
  local dataType = attributes["__typename"];
  WARNING(dataType .. " not support as literal or default")
  return nil
end

bluedeserializaion._InstantiationBlueNode = function(typename, bluegraph, key, attributes)
  local node = nil;
  --if typename == "BlueNode" then    继承bluenode的bluedynamicnode等用相同的反序列化方法
    local location = attributes["luaPath"];
    if location ~= nil then
      if type(location) == 'table' and location.__typename == 'BlueNode' then -- 动态生成的节点类
        attributes["luaPath"] = nil ;
        local base_cls_path = attributes[BD.BaseClass]
        local cls_spec_data = {}
        -- 移除__typename,pairs不会遍历metatable
        for k, v in pairs(attributes[BD.SpecData]) do
          if k:find("__") == 1 then
            if _KRATOSEDITOR then LOG("[GetNodeClass] ignore "..tostring(k)) end
          else
            cls_spec_data[k] = v
          end
        end
        -- 先查找 bluegraphic中是否已经extend这个节点类
        local cls = bluegraph:GetNodeClass(base_cls_path, cls_spec_data)
        if cls ~= nil then
          node = cls(bluegraph);
          return node ;
        else
          local template = require(base_cls_path)
          cls = template:extend(bluegraph, cls_spec_data)
          bluegraph:AddNodeClass(base_cls_path, cls_spec_data, cls)
          node = cls(bluegraph);
          return node;
        end
      elseif type(location) == 'string' then -- 对应lua文件的节点类
        --LOG("Deserial  "..tostring(location))
        local cls = require(location)
        node = cls(bluegraph)
      else
        assert(false ,"[_InstantiationBlueNode][Fatal] location is confused?");
      end
    else
      assert(false, "[_InstantiationBlueNode] location is empty");
    end
  --else
  --  assert(false,"[_InstantiationBlueNode][Fatal] not bluenode");
  --end
  return node;

end


bluedeserializaion._InstantiationBlueVariableInfo = function (typename, attributes, blueprint)

  local node = nil;
  -- LOG("BlueVariableInfo typename  "..tostring(typename))
  if typename == "BlueVariableInfo" then
    --LOG("BlueVariableInfo base "..tostring(attributes["base_rtti_name"])
    --              ..", is_array "..tostring(attributes["is_array"]))
    local var = BluePrintVariable(blueprint, attributes["base_rtti_name"], attributes["is_array"]);
    return var ;
  else
    assert("[_InstantiationBlueVariableInfo][Fatal] not BlueVariableInfo");
  end
  return node;
end

bluedeserializaion._InstantiationBlueFuncInfo = function (typename, attributes, blueprint)

  local node = nil;
  if typename == "BlueFunctionPinInfo" then
    local var = BlueFunctionInfo(attributes["base_rtti_name"], attributes["is_array"]);
    return var ;
  else
    assert("[_InstantiationBlueFuncInfo][Fatal] not BlueFunctionInfo");
  end
  return node;
end


libvenuscore.BundleSystem:OnDeserialize("BluePinInfo",
        function(cls,attributes)
          for name, attr in pairs(attributes) do
            cls:SetScriptValue(name,attr);
          end
          cls:_OnDeserialize();
      end
)


return bluedeserializaion