local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
require "utility"
local shine= {}
shine.MotionMaterial  = 0;
shine.MotionRenderObj  = 0;
shine.SeperateBlursMaterial = {};
shine.SeperateBlursRenderObj = {};
shine.VolumnLightMaterial = 0;
shine.VolumnLightRenderObj = 0;
shine.Rt1 = 0;
shine.Rt2 = 0;
shine.BlurCount = 3;
shine.Queue = 100;

function shine:Initialize(host, size)  
  self.CUR_FRAME_TEXTURE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "CUR_FRAME_TEXTURE");
  self.PRE_FRAME_TEXTURE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "PRE_FRAME_TEXTURE");
  self.MOTION_TEXTURE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "MOTION_TEXTURE");
  self.RADIUS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "RADIUS");      
  self.UNIFORM_OFFSET = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_OFFSET");      
  self.FRAME_TEXTURE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "FRAME_TEXTURE");      
  self.BRIGHT_TEXTURE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "BRIGHT_TEXTURE");    
  self.UNIFORM_LIGHT_COLOR = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_LIGHT_COLOR");  
  self.SAMPLES = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "SAMPLES");      
  self.STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "STEP");      
  
  self.MotionMaterial  = host:CreateMaterial( "docs:material/shinemotion.material" );
  self.MotionRenderObj = host:CreateRenderObject();
  
  local blur_radius = 3.0;
  local blur1Material  = host:CreateMaterial( "docs:material/shineseperateblur.material" );
  local blur1RenderObj = host:CreateRenderObject();
  blur1Material:SetParameter(self.RADIUS, mathfunction.vector1(blur_radius));
--   local m = 1.0 / size:x();
--   local n = 1.0 / size:y();

  blur1Material:SetParameter(self.UNIFORM_OFFSET, mathfunction.vector2(1.0 / size:x(), 0.0));
  table.insert(self.SeperateBlursMaterial, blur1Material);
  table.insert(self.SeperateBlursRenderObj, blur1RenderObj);
  
  local blur2Material  = host:CreateMaterial( "docs:material/shineseperateblur.material" );
  local blur2RenderObj = host:CreateRenderObject();
  blur2Material:SetParameter(self.RADIUS, mathfunction.vector1(blur_radius));
  blur2Material:SetParameter(self.UNIFORM_OFFSET, mathfunction.vector2(0.0, 1.0 / size:y()));
  table.insert(self.SeperateBlursMaterial, blur2Material);
  table.insert(self.SeperateBlursRenderObj, blur2RenderObj);

  self.VolumnLightMaterial  = host:CreateMaterial( "docs:material/shinevolumnlight.material" );
  self.VolumnLightRenderObj = host:CreateRenderObject();
  
  self.Rt1 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size);
  self.Rt2 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size);
  
  return self.Queue;
end

function shine:Resizeview(size)
    self.SeperateBlursMaterial[1]:SetParameter(self.UNIFORM_OFFSET, mathfunction.vector2(1.0 / size:x(), 0.0));
    self.SeperateBlursMaterial[2]:SetParameter(self.UNIFORM_OFFSET, mathfunction.vector2(0.0, 1.0 / size:y()));
end

function shine:Process(context, Original, Scene, Output)


  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  context:Draw(self.MotionRenderObj, self.MotionMaterial);
  context:EndRenderPass();

  for i = 1,self.BlurCount do
    context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
    self.SeperateBlursMaterial[1]:SetParameter(self.MOTION_TEXTURE,
        self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );      
    context:Draw(self.SeperateBlursRenderObj[1], self.SeperateBlursMaterial[1]);
    context:EndRenderPass();

    context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
    self.SeperateBlursMaterial[2]:SetParameter(self.MOTION_TEXTURE,
        self.Rt2:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
    context:Draw(self.SeperateBlursRenderObj[2], self.SeperateBlursMaterial[2]);
    context:EndRenderPass();
  end

  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.VolumnLightMaterial:SetParameter(self.BRIGHT_TEXTURE,
        self.Rt1:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
  context:Draw(self.VolumnLightRenderObj, self.VolumnLightMaterial);
  context:EndRenderPass();

end

return shine;