local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local lut = require "apolloengine.posteffect.lut"

local lut_alpha = {};

setmetatable(lut_alpha, {__index = lut});

function lut_alpha:Initialize(host, size)
  self.alphaFactor = mathfunction.vector1(1.0);
  self.ALPHA_FACTOR = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "ALPHA_FACTOR");

  lut.Initialize(self, host, size);

  self.DoMaterial:SetParameter(self.POST_EFFECT_ALPHA, mathfunction.vector1(0.0));
  self.DoMaterial:SetParameter(self.ALPHA_FACTOR, self.alphaFactor);

  host:RegisterScriptParameter(self, "alphaFactor");

  return self.Queue;
end

function lut_alpha:Process(context, Original, Scene, Output)
  self.DoMaterial:SetParameter(self.ALPHA_FACTOR, self.alphaFactor);
  lut.Process(self, context, Original, Scene, Output);
end

return lut_alpha;