
#SHADER_DEFINE reflectionVertex

FUNCTION_INPUT =
{
	{ ATTRIBUTE_POSITION, HIGH, VEC4, "in_Position" },
	{ ATTRIBUTE_NORMAL, HIGH, VEC3, "in_Normal" },
	{ ATTRIBUTE_TANGENT, HIGH, VEC3, "in_Tangent" },
	{ ATTRIBUTE_BINORMAL, HIGH, VEC3, "in_Binormal" },
	{ LOCALWORLD_TRANSFORM, HIGH, MAT4, "in_Transfrom" },
	{ CAMERA_VIEWPROJ, HIGH,	MAT4, "in_ViewPorj" },
	{ LOCALWORLD_ROTATION,HIGH, MAT3,"in_WorldRotation" },
	{ ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"in_Coordinate" },
}

FUNCTION_OUTPUT =
{
	{ WORLDSPACE_POSITION, HIGH, VEC4, "out_PositionWS" },
	{ WORLDSPACE_NORMAL, HIGH, VEC3, "out_Normal" },
	{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,"Out_Coordinate" },
	{ ATTRIBUTE_COORDNATE1, HIGH, VEC3, "out_Tangent" },
	{ ATTRIBUTE_COORDNATE2, HIGH, VEC3, "out_Binormal" },
}

#SHADER_CODE
gl_Position = in_ViewPorj * in_Transfrom * in_Position;
vec4 out_PositionWS = in_Transfrom * in_Position;
vec3 out_Normal = in_WorldRotation * in_Normal;
vec3 out_Tangent = in_WorldRotation * in_Tangent;
vec3 out_Binormal = in_WorldRotation * in_Binormal;
mediump vec2 Out_Coordinate = in_Coordinate;

#END_CODE
#END_DEFINE

#SHADER_DEFINE reflectionFragment


FUNCTION_INPUT =
{
	{ WORLDSPACE_POSITION, HIGH, VEC4, "out_PositionWS" },
	{ CAMERA_WORLDPOSITION,HIGH,VEC3, "in_WorldCamPos" },
	{ TEXTURE_REFLECTION, NONE, TEXTURE2D, "in_ReflectionTexture" },
	{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
	{ TEXTURE_NORMAL, NONE, TEXTURE2D, "in_BumpTex"},
	{ TEXTURE_EMSSION, NONE, TEXTURE2D, "in_EmssionTex"},
	{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
	{ UNIFORM_REFFACTOR, HIGH, FLOAT, "in_Reffactor" },
	{ WORLDSPACE_NORMAL, HIGH, VEC3, "v_worldNormal" },
	{ ATTRIBUTE_COORDNATE1, HIGH, VEC3, "v_worldTangent" },
	{ ATTRIBUTE_COORDNATE2, HIGH, VEC3, "v_worldBiTangent" },
}

FUNCTION_OUTPUT =
{
	{ SURFACE_COLOR, LOW, VEC4,	"out_SurfaceColor" },
}

#SHADER_CODE

vec4 diffTexColor = texture2D(in_DiffuseTexture, in_Coordinate);
vec4 emssionTexColor = texture2D(in_EmssionTex, in_Coordinate);
vec4 normalTexColor = texture2D(in_BumpTex, in_Coordinate);

if (diffTexColor.a < 0.5)
	discard;
vec3 normal = normalTexColor.rgb - 0.5;
normal = normalize(normal);
if (!gl_FrontFacing)
normal = -normal;

mat3 tangentSpace = mat3(v_worldTangent,
	v_worldBiTangent,
	v_worldNormal);

vec3 v_worldViewDir = normalize(vec3(out_PositionWS.xyz) - in_WorldCamPos);
vec3 worldNormal = normalize(tangentSpace*normal);
vec3 refCoord = reflect(v_worldViewDir, worldNormal);

vec3 ref = normalize(refCoord) + vec3(0.0, 0.0, 1.0);
float len2 = 2.0*sqrt(ref.x*ref.x + ref.y*ref.y + ref.z*ref.z);
vec2 texCoord = vec2(0.5 + ref.x / len2, 0.5 - ref.y / len2);

vec3 planeRefColor = texture2D(in_ReflectionTexture, in_Coordinate).rgb * in_Reffactor;


gl_FragColor.rgb = diffTexColor.rgb*0.5+vec3(texCoord.y, texCoord.y, texCoord.y) + emssionTexColor.rgb;
gl_FragColor.a = diffTexColor.a;

#END_CODE
#END_DEFINE




