

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
BOLD = {"bold", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "sdffont3d"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
    float2 vertex : POSITION;
    float2 uv : TEXCOORD0;
    float4 color : COLOR0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
    float4 color : COLOR0;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_SAMPLER;
float BOLD;

v2f vert(appdata v)
{
    v2f o;
    float4 pos =ObjectToClipPos(float4(v.vertex * 0.001,0.0,1.0));
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    o.color = v.color;
    return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0) 
{
    float distance_mark = 0.5;
    float smooth_delta = 0.1;
    outColor= TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, i.uv);
    float distance = outColor.a + 0.2 * BOLD;
    outColor.a = smoothstep(distance_mark - smooth_delta, distance_mark + smooth_delta, distance);
    outColor.rgb = i.color.rgb;
}
ENDCG
#END
