#DEFPARAMS
_MainTex  = { "MainTex",  TEXTURE2D,  "white"      },
_MainSize = { "MainSize", VEC2,       "4.0, 4.0"   },
_Step     = { "Step",     VEC2,       "0.0, 0.0"   },
#END

#DEFTAG
ShaderName = "MedianBlur"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
//#include "rgb_hsv.inc"

struct appdata
{
  float4 vertex : POSITION;
  float2 uv : TEXCOORD0;
};

struct v2f
{
  float4 vertex : SV_POSITION;
  float2 uv : TEXCOORD0;
};

Texture2D _MainTex;
SamplerState _MainSampler;
float2 _MainSize;
float2 _Step;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);  
    o.uv = v.uv.xy;
    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float2 step = _Step / _MainSize;
    
    float3 color1 = _MainTex.Sample(_MainSampler, i.uv - step).rgb;
    float3 color2 = _MainTex.Sample(_MainSampler, i.uv).rgb;
    float3 color3 = _MainTex.Sample(_MainSampler, i.uv + step).rgb;

    float3 minColor = min(color1, min(color2, color3));
    float3 maxColor = max(color1, max(color2, color3));

    float3 midColor = color1 + color2 + color3 - minColor - maxColor;

    mainColor = float4(midColor, 1.0);
}
ENDCG
#END
