#SHADER_DEFINE ColorInvertFilterVertex

	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE


#SHADER_DEFINE ColorInvertFilterFragment 

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
    { COUNT, 		HIGH,	FLOAT,		"count"},
	}

#SHADER_CODE

     
     vec3 curr = texture2D(uniCurrentTexture,in_TexCooridate).xyz;
     gl_FragColor = step(1.0,count)*vec4(vec3(1.0)-curr,1.0)+(1.0-step(1.0,count))*vec4(curr,1.0);

#END_CODE
#END_DEFINE