

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
_MaskTex = { "mask Tex", TEXTURE2D, "white" },
_TexAspect = {"TexAspect", FLOAT, "1.0"},
_ScaleX = { "scale_x", FLOAT, "1.0" },
_ScaleY = { "scale_y", FLOAT, "1.0" },
_PosX = { "pos_x", FLOAT, "0.0" },
_PosY = { "pos_y", FLOAT, "0.0" },
#END


#DEFTAG
ShaderName = "camera_quad"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_ALWAYS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_skin
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float2 maskuv : TEXCOORD1;
	float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
Texture2D _MaskTex;
SamplerState _MainSampler;
SamplerState _MaskTexSampler;
float     _TexAspect;
float _ScaleX;
float _ScaleY;
float _PosX;
float _PosY;


v2f vert(appdata v)
{
    v2f o;
    float2 in_WorldScale = float2(_ScaleX, _ScaleY);
    float4 pos = float4(v.vertex * in_WorldScale / 100.0 + float2(_PosX, _PosY), 0.0, 1.0);
    o.vertex = UniformNDC(pos);
	float2 mainUV = v.uv;
	float winAspect = 9.0 / 16.0 * _ScaleX / _ScaleY;
	float ratio = _TexAspect / winAspect;
	if(ratio <= 1.0)
    {
    	mainUV = float2(v.uv.x, clamp(v.uv.y, 0.5 - ratio/2.0, 0.5 + ratio/2.0));
    }
    else
    {
    	mainUV = float2(clamp(v.uv.x, 0.5 - ratio/2.0, 0.5 + ratio/2.0), v.uv.y);
    }
	o.uv = mainUV;
    o.maskuv = v.uv.xy;
	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	// sample the texture
	float4 mainColor = _MainTex.Sample(_MainSampler, i.uv);
	float4 maskColor = _MaskTex.Sample(_MaskTexSampler,i.maskuv);
	outColor = float4(mainColor.r,mainColor.g,mainColor.b,maskColor.a);

}
ENDCG
#END
