#DEFPARAMS
_BorderTex = { "borderTex", TEXTURE2D, "white" },
_MainTex = { "bloodTex", TEXTURE2D, "white" },
_TexAspect = {"TexAspect", FLOAT, "1.0"},
_HP = {"HP", FLOAT, "1.0"},
[Keywords(Left, Right)]
_Side = {"side", FLOAT, "1.0"},
_ScaleX = { "scale_x", FLOAT, "1.0" },
_ScaleY = { "scale_y", FLOAT, "1.0" },
_PosX = { "pos_x", FLOAT, "0.0" },
_PosY = { "pos_y", FLOAT, "0.0" },
_PosZ = { "pos_z", FLOAT, "0.0" },
#END


#DEFTAG
ShaderName = "Blood_Bar"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_ALWAYS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile Left Right
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D _BorderTex;
Texture2D _MainTex;
SamplerState _BorderTexSampler;
SamplerState _MainTexSampler;
float _TexAspect;
float _HP;
float _ScaleX;
float _ScaleY;
float _PosX;
float _PosY;
float _PosZ;

v2f vert(appdata v)
{
	v2f o;
	v.vertex.x = v.vertex.x * (step(0.999, _TexAspect)*_TexAspect + step(_TexAspect, 0.999));
	v.vertex.y = v.vertex.y * (step(0.999, _TexAspect) + step(_TexAspect, 0.999)/_TexAspect);
	float2 in_WorldScale = float2(_ScaleX, _ScaleY);
    float4 pos = float4(v.vertex * in_WorldScale / 1000.0 + float2(_PosX, _PosY), _PosZ, 1.0);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	// sample the texture
	mainColor = _BorderTex.Sample(_BorderTexSampler, i.uv);
	float2 uv = i.uv;
	float hp = 1.0-_HP;
	#if Left
		hp = -(1.0-_HP);
	#endif
	uv.x = uv.x + hp;
	if(uv.x>0.0 && uv.x<1.0 && mainColor.w>0.001)
	{
		float4 blood = _MainTex.Sample(_MainTexSampler, uv);
		if(blood.w>0.001)
		{
			mainColor = blood;
		}
	}
}
ENDCG
#END
