#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
_ScaleX = { "scale_x", FLOAT, "1.0" },
_ScaleY = { "scale_y", FLOAT, "1.0" },
_PosX = { "pos_x", FLOAT, "0.0" },
_PosY = { "pos_y", FLOAT, "0.0" },
_TexAspect = {"TexAspect", FLOAT, "1.0"}
#END

#DEFTAG
ShaderName = "avatar"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_ALWAYS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
    float2 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
SamplerState _MainTex_Sampler;
float _TexAspect;
float _ScaleX;
float _ScaleY;
float _PosX;
float _PosY;

v2f vert(appdata v)
{
    float2 in_WorldScale = float2(_ScaleX, _ScaleY);
    float4 cpos = ObjectToClipPos(float4(0,0,0,1));
    float4 pos = float4(v.vertex * in_WorldScale / 1000.0 + cpos.xy/cpos.w + float2(_PosX, _PosY), 0.0, 1.0);

    //v.vertex.x = v.vertex.x * (step(0.999, _TexAspect)*_TexAspect + step(_TexAspect, 0.999));
	//v.vertex.y = v.vertex.y * (step(0.999, _TexAspect) + step(_TexAspect, 0.999)/_TexAspect);

    v2f o;
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    mainColor = _MainTex.Sample(_MainTex_Sampler, i.uv);
    float2 p = i.uv-float2(0.5,0.5);
    float len = dot(p,p);
    if(len>0.25)
    {
        mainColor.w = 0.0;
    }
}
ENDCG
#END