local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

--简单meshode
local MeshNode = apollonode.RenderNode:extend();
function MeshNode:new()
  MeshNode.super.new(self)
  self.uniformList = {};
  
  --test
  self.rotation = mathfunction.Quaternion();

  self.begintime = venuscore.ITimerSystem:GetTimevalue();
end

function MeshNode:SetMaterialPath(materialpath)
  --[[
  self.render:PushMetadata(
      apolloengine.RenderObjectMaterialMetadata(
        apolloengine.PathMetadata(materialpath)));]]
  local materialEntity = self.render:MakeMaterialAttachment();
  materialEntity:PushMetadata(apolloengine.PathMetadata(materialpath));
  self.material = materialEntity;
  LOG("SET MAT PATH "..materialpath)
end


function MeshNode:SetMaterialBuffer(materialbuffer)
end

function MeshNode:SetMeshPath(meshpath,memoryusage)
  if memoryusage == nil then
    memoryusage = apolloengine.VertexBufferEntity.MU_STATIC;
  end   

  self.render:PushMetadata(
		apolloengine.RenderObjectMeshFileMetadate(memoryusage, meshpath));
end

function MeshNode:SetupUniforms(slot,value)
  table.insert(self.uniformList,{slot,value});
end

function MeshNode:_ApplyUniform()
  local uniformCnt = #self.uniformList;
  for i = 1, uniformCnt do
    self:SetParameter(self.uniformList[i][1],self.uniformList[i][2]);
  end
end

function MeshNode:PushTextureMetadata(slot, imagepath, clampMode)
  --[[
    self.render:PushMetadata(--传入纹理原始数据TW_CLAMP_TO_EDGE
    apolloengine.RenderObjectTextureMetadata(
    slot,
    apolloengine.TextureFileMetadata(
      apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,
      1, true,
      clampMode or apolloengine.TextureEntity.TW_REPEAT,--默认repeat
      clampMode or apolloengine.TextureEntity.TW_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
      imagepath)));]]--

  self.material:PushTextureMetadata(slot,apolloengine.TextureFileMetadata(
    apolloengine.TextureEntity.TU_STATIC,
    apolloengine.TextureEntity.PF_AUTO,
    1, false,
    clampMode or apolloengine.TextureEntity.TW_REPEAT,--默认repeat
    clampMode or apolloengine.TextureEntity.TW_REPEAT,
    apolloengine.TextureEntity.TF_LINEAR,
    apolloengine.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
    imagepath) );
 -- LOG("ADD TEXTURE "..imagepath )
end

function MeshNode:PushTextureMetadataUsingMipmap(slot, imagepath, clampMode)
  --[[
    self.render:PushMetadata(--传入纹理原始数据TW_CLAMP_TO_EDGE
    apolloengine.RenderObjectTextureMetadata(
    slot,
    apolloengine.TextureFileMetadata(
      apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,
      1, true,
      clampMode or apolloengine.TextureEntity.TW_REPEAT,--默认repeat
      clampMode or apolloengine.TextureEntity.TW_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
      imagepath)));]]--

  self.material:PushTextureMetadata(slot,apolloengine.TextureFileMetadata(
    apolloengine.TextureEntity.TU_STATIC,
    apolloengine.TextureEntity.PF_AUTO,
    1, true,
    clampMode or apolloengine.TextureEntity.TW_REPEAT,--默认repeat
    clampMode or apolloengine.TextureEntity.TW_REPEAT,
    apolloengine.TextureEntity.TF_LINEAR,
    apolloengine.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
    imagepath) );
 -- LOG("ADD TEXTURE "..imagepath )
end

function MeshNode:PushTextureMetadataWithMipmap(slot, imagepath, level)
  --[[
    self.render:PushMetadata(--传入纹理原始数据TW_CLAMP_TO_EDGE
    apolloengine.RenderObjectTextureMetadata(
    slot,
    apolloengine.TextureFileMetadata(
      apolloengine.TextureEntity.TT_TEXTURE2D,
      level,
      imagepath)));]]


  self.material:PushTextureMetadata(slot,apolloengine.TextureFileMetadata(
    apolloengine.TextureEntity.TT_TEXTURE2D,
    level,
    imagepath) );
  LOG("ADD TEXTURE 2 "..imagepath )
end

function MeshNode:SetKeepSource(iskeepsource)
    self.render:SetKeepSource(iskeepsource)
end

function MeshNode:CreateResource()
  LOG("CREATE RESOURCE")
  local res = self.render:CreateResource();
  self:_ApplyUniform();
  return res;
end

function MeshNode:Update(def)
  --self.rotation = self.rotation * mathfunction.Mathutility:RotateAxis(
  --mathfunction.vector3(0,1,0), math.pi / 4 * def);
  --self:SetLocalRotation(self.rotation);
  --local position = self:GetLocalPosition();
  --position = position + mathfunction.vector3(0.0,0.0,-0.02) * def;
  --self:SetLocalPosition(position);
end

function MeshNode:AttachBlendshape(dir, names)
  self.blendshape = self.node:CreateComponent(apolloengine.Node.CT_BLENDSHAPE);
  self.nameMap = {};
  for i=1, #names do
    local path = dir .. names[i] .. ".mesh";
    self.nameMap[names[i]] = i;
    self.blendshape:PushMetadata(
      apolloengine.FileVertexMetadata(apolloengine.VertexBufferEntity.MU_STATIC, path));
  end
  local res = self.blendshape:CreateResource();
end

function MeshNode:AttachMorpher(dir, morpherconfig)
  
  local clip = morpherconfig.morpher[1]; -- select 1 as default clip
  local modelconfig = clip.modellist[1]

  self.morpher = self.node:CreateComponent(apolloengine.Node.CT_MORPH);
  self.morpher:PushMetadata(dir .. modelconfig.path);
  self.channelmap = {}
  self.groupmap = {}
  
  for _, group in modelconfig.group do
    local grpIndex = self.morpher:CreateGroup(group.gid, group.name)
    for _, channel in group.channels do
      --self.channel_map[names[i]] = channels[i].cid
      local targetPositionList = channel.position 
      local targetNormalList = channel.normal
      local weightList = channel.weights

      if targetPositionList ~= nil and targetNormalList~= nil and weightList ~= nil
              and #targetPositionList == #weightList and  #targetPositionList == #weightList then
        local index = self.morpher:CreateChannel(grpIndex, channel.cid, channel.name)
        self.channelmap[names[i]] = index
        self.groupmap[names[i]] = grpIndex
        for t = 1 , #weightList do
          self.morpher:OfferTargets(grpIndex, index, targetPositionList[t], targetNormalList[t], weightList[t]);
        end
      else
        ERROR("size not equal "..tostring(#targetPositionList).." fail == "..tostring(#weightList));
      end
    end
  end
  
  self.morpher:CreateResource()
  self.morpher:OnDeserializeFinished()
  return true
end

function MeshNode:UpdateExpression(detect_data)
  if detect_data == nil then
    return;
  end
  if self.blendshape ~= nil then
    local face_weights = {};
    local weights_dict = detect_data.weights_dict;
    for name, index in pairs(self.nameMap) do
      face_weights[index] =  weights_dict[name] or 0;
    end
    self.blendshape:SetBlendShapeWeights(face_weights);
    self.blendshape:Update();
  elseif self.morpher ~= nil then
    local weights_dict = detect_data.weights_dict;
    for name, id in pairs(self.channelmap) do
      local weight = weights_dict[name] or 0
      self.morpher:SetChannelPercents(self.groupmap[name], id, weight)
    end
    self.morpher:Update(0)
  else
    return;
  end
  
end


return MeshNode;