local Object       = require "classic"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local apollonode   = require "apolloutility.apollonode"
local venuscore    = require "venuscore"
local defined      = require "apolloutility.defiend"
local apollocore = require "apollocore"

local HairColorRender = Object:extend();

function HairColorRender:new(scene, Node, name, material_path)
    self.initialized  = false;
    self.scene        = scene;
    local subNodes = Node:GetChildrens();
    for childname, childnode in pairs(subNodes) do
        if childnode.Name == name then
            self.node = childnode;
            self.render = self.node:GetComponent(apolloengine.Node.CT_RENDER);
            
        end
    end
    
    if _KRATOSEDITOR then
        self.node.EditorUIType = apollocore.IContent.UNVISUAL;
    end
    self.isshow       = true;
    self.initialized   = true;
end

function HairColorRender:SetShow(isshow)
    if not self.initialized then
        return;
    end

    if self.isshow ~= isshow then
        self.isshow = isshow;
        if isshow then
          self.render:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
        else
          self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
        end  
    end
end

function HairColorRender:SetParameter(key, value)
    if key == nil or value == nil then
        LOG("[HairColorRender] SetParameter nil "..key);
        return;
    end

    if self.initialized then
        self.render:SetParameter(key, value);
    end
end

function HairColorRender:Destroy()
    local scene = self.scene;
    if not venuscore.isNil(self.node) then  --防止Node重复删除(因为删除父Node会递归删除子Node)
      scene:DeleteNode(self.node);
      self.node = nil;
      self.render = nil;
      self.scene = nil;
    end

end

function HairColorRender:SetResourceType(resType)
    if self.initialized then
        self.render:SetResourceType(resType);
    end
end
  
function HairColorRender:GetResourceType()
    if self.initialized then
        return self.render:GetResourceType();
    end
    return
end
  

return HairColorRender;
