local b3 = require "behavior3"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
local TrigBehavior = require "facecute.behavior"
local behdefined = require "facecute.behavior.behdefined"

local cutebehavior={}


function cutebehavior:Initialize()
  self.behaviortree = b3.BehaviorTree.new();
  self.blackboard = b3.Blackboard.new();  
  local fullpath = vc.IFileSystem:PathAssembly(behdefined.behaviorPath[1]);
  local behavior = cjson.decode(cjutil.file_load(fullpath));
  self.behaviortree:load(behavior, TrigBehavior);
end

function cutebehavior:tick(target)
  self.behaviortree:tick(target,self.blackboard);
end

return cutebehavior;