local Venuscore = require "venuscore"
local Apolloengine = require "apolloengine"
local defined = require "apolloutility.defiend"
local SkeletonBehavior = Venuscore.VenusBehavior:extend("SkeletonBehavior"); 

local rootBone   = "Pelvis";
local spineBones = {}
local bonesNames = {};
local colliders = {};
local laplacianextras = {};

table.insert( colliders, "HeadCol" );
table.insert( colliders, "RForearmCol" );
table.insert( colliders, "LForearmCol" );
table.insert( colliders, "LKneeCol" );
table.insert( colliders, "RKneeCol" );
table.insert( colliders, "SpineCol" );
    
table.insert( spineBones, "Spinebase" );
table.insert( spineBones, "Spinemid" );
table.insert( spineBones, "Spineshoulder" );

table.insert( bonesNames, "R_Shoulder" );
table.insert( bonesNames, "R_Elbow" );
table.insert( bonesNames, "R_Wrist" );
table.insert( bonesNames, "R_Hand" );
table.insert( bonesNames, "R_HandTip" );
table.insert( bonesNames, "R_Thumb" );
table.insert( bonesNames, "L_Shoulder" );
table.insert( bonesNames, "L_Elbow" );
table.insert( bonesNames, "L_Wrist" );
table.insert( bonesNames, "L_Hand" );
table.insert( bonesNames, "L_HandTip" );
table.insert( bonesNames, "L_Thumb" );
table.insert( bonesNames, "R_Hip" );
table.insert( bonesNames, "R_Knee" );
table.insert( bonesNames, "R_Ankle" );
table.insert( bonesNames, "R_Foot" );
table.insert( bonesNames, "L_Hip" );
table.insert( bonesNames, "L_Knee" );
table.insert( bonesNames, "L_Ankle" );
table.insert( bonesNames, "L_Foot" );
table.insert( bonesNames, "Neck" );
table.insert( bonesNames, "Head" );

table.insert( laplacianextras,"headR")
table.insert( laplacianextras,"headL")
table.insert( laplacianextras,"headF")
table.insert( laplacianextras,"headB")
table.insert( laplacianextras,"bodyR")
table.insert( laplacianextras,"bodyL")
table.insert( laplacianextras,"bodyF")
table.insert( laplacianextras,"bodyB")

local children = {2,3,4,5,0,0,8,9,10,11,0,0,14,15,16,0,18,19,20,0,22,0};
local bodyPair = {{1,2},{3,4},{1,3},{2,4}};

function SkeletonBehavior:new()

    self.Pelvis = nil;

    self.Spinebase = nil;
    self.Spinemid = nil;
    self.Spineshoulder = nil;

    self.R_Shoulder = nil;
    self.R_Elbow    = nil;
    self.R_Wrist    = nil;
    self.R_Hand     = nil;
    self.R_HandTip  = nil;
    self.R_Thumb    = nil;

    self.L_Shoulder = nil;
    self.L_Elbow    = nil;
    self.L_Wrist    = nil;
    self.L_Hand     = nil;
    self.L_HandTip  = nil;
    self.L_Thumb    = nil;

    self.R_Hip      = nil;
    self.R_Knee     = nil;
    self.R_Ankle    = nil;
    self.R_Foot     = nil;

    self.L_Hip      = nil;
    self.L_Knee     = nil;
    self.L_Ankle    = nil;
    self.L_Foot     = nil;

    self.Neck       = nil;
    self.Head       = nil;
    
    self.Target = nil;


   
end

function  SkeletonBehavior:_OnAwake()
  self.attrootBone   = "SkeletonNode";
  self.attspineBones = {};
  self.attbonesNames = {};
  
  self.attcolliders = {};
  
  self.attlaplacianextras = {};
  
  table.insert( self.attcolliders, "HEAD" );
  table.insert( self.attcolliders, "ELBOW_RIGHT" );
  table.insert( self.attcolliders, "ELBOW_LEFT" );
  table.insert( self.attcolliders, "KNEE_LEFT" );
  table.insert( self.attcolliders, "KNEE_RIGHT" );
  table.insert( self.attcolliders, "SPINE_MID" );

  table.insert( self.attspineBones, "SPINE_BASE" );
  table.insert( self.attspineBones, "SPINE_MID" );
  table.insert( self.attspineBones, "SPINE_SHOULDER" );
  
  table.insert( self.attbonesNames, "SHOULDER_RIGHT" );
  table.insert( self.attbonesNames, "ELBOW_RIGHT" );
  table.insert( self.attbonesNames, "WRIST_RIGHT" );
  table.insert( self.attbonesNames, "HAND_RIGHT" );
  table.insert( self.attbonesNames, "HAND_TIP_RIGHT" );
  table.insert( self.attbonesNames, "THUMB_RIGHT" );
  table.insert( self.attbonesNames, "SHOULDER_LEFT" );
  table.insert( self.attbonesNames, "ELBOW_LEFT" );
  table.insert( self.attbonesNames, "WRIST_LEFT" );
  table.insert( self.attbonesNames, "HAND_LEFT" );
  table.insert( self.attbonesNames, "HAND_TIP_LEFT" );
  table.insert( self.attbonesNames, "THUMB_LEFT" );
  table.insert( self.attbonesNames, "HIP_RIGHT" );
  table.insert( self.attbonesNames, "KNEE_RIGHT" );
  table.insert( self.attbonesNames, "ANKLE_RIGHT" );
  table.insert( self.attbonesNames, "FOOT_RIGHT" );
  table.insert( self.attbonesNames, "HIP_LEFT" );
  table.insert( self.attbonesNames, "KNEE_LEFT" );
  table.insert( self.attbonesNames, "ANKLE_LEFT" );
  table.insert( self.attbonesNames, "FOOT__LEFT" );
  table.insert( self.attbonesNames, "NECK" );
  table.insert( self.attbonesNames, "HEAD" );
  
  table.insert( self.attlaplacianextras, "boxR" );
  table.insert( self.attlaplacianextras, "boxL" );
  table.insert( self.attlaplacianextras, "boxF" );
  table.insert( self.attlaplacianextras, "boxB" );
  table.insert( self.attlaplacianextras, "bodyR")
  table.insert( self.attlaplacianextras, "bodyL")
  table.insert( self.attlaplacianextras, "bodyF")
  table.insert( self.attlaplacianextras, "bodyB")

 
  for i=1,#self.attbonesNames do
    if self[bonesNames[i]]==nil then
      self[bonesNames[i]] = self.Node:GetRoot():GetNodeByName(self.attbonesNames[i]);
    end
    if self[bonesNames[i]]==nil then
        LOG(bonesNames[i] .." NOT FOUND ");
    end
  end

  for i=1,#self.attspineBones do
    if self[spineBones[i]]==nil then
      self[spineBones[i]] = self.Node:GetRoot():GetNodeByName(self.attspineBones[i]);
    end
    if self[spineBones[i]]==nil then
        LOG(spineBones[i] .." NOT FOUND ");
    end
  end
  
  for i=1,#self.attlaplacianextras do
    if self[laplacianextras[i]]==nil then
      self[laplacianextras[i]] = self.Node:GetRoot():GetNodeByName(self.attlaplacianextras[i]);
    end
    if self[laplacianextras[i]]==nil then
        LOG(laplacianextras[i] .." NOT FOUND ");
    else
       LOG(laplacianextras[i] .."IS FOUND ");
    end
  end

  for i=1,#self.attcolliders do
    if self[colliders[i]]==nil then
      local node = self.Node:GetRoot():GetNodeByName(self.attcolliders[i]);
      if node ~= nil then
        self[colliders[i]] = node:GetComponent(Apolloengine.Node.CT_SHAPECOLLIDER);
      end
    end
    if self[colliders[i]]==nil then
      LOG(colliders[i] .." NOT FOUND ");
    else
      LOG(colliders[i] .." IS FOUND ");
    end
  end
  
  self[rootBone] = self.Node:GetRoot():GetNodeByName(self.attrootBone);
end

function SkeletonBehavior:Init()
  self.BoneNodes = 
  {
      ["Pelvis"] = self.Pelvis,

      ["Spinebase"] = self.Spinebase,
      ["Spinemid"] = self.Spinemid,
      ["Spineshoulder"] = self.Spineshoulder,

      ["R_Shoulder"] = self.R_Shoulder,
      ["R_Elbow"] = self.R_Elbow,
      ["R_Wrist"] = self.R_Wrist,
      ["R_Hand"]  = self.R_Hand,
      ["R_HandTip"]  = self.R_HandTip,
      ["R_Thumb"]  = self.R_Thumb,

      ["L_Shoulder"] = self.L_Shoulder,
      ["L_Elbow"] = self.L_Elbow,
      ["L_Wrist"] = self.L_Wrist,
      ["L_Hand"]  = self.L_Hand,
      ["L_HandTip"]  = self.L_HandTip,
      ["L_Thumb"]  = self.L_Thumb,

      ["R_Hip"] = self.R_Hip,
      ["R_Knee"] = self.R_Knee,
      ["R_Ankle"] = self.R_Ankle,
      ["R_Foot"] = self.R_Foot,

      ["L_Hip"] = self.L_Hip,
      ["L_Knee"] = self.L_Knee,
      ["L_Ankle"] = self.L_Ankle,
      ["L_Foot"] = self.L_Foot,

      ["Neck"] = self.Neck,
      ["Head"] = self.Head
  }

  self.BoneNames = {
    self.R_Shoulder.Name,
    self.R_Elbow.Name,   
    self.R_Wrist.Name,  
    self.R_Hand.Name,
    self.R_HandTip.Name,
    self.R_Thumb.Name,   

    self.L_Shoulder.Name,
    self.L_Elbow.Name, 
    self.L_Wrist.Name,  
    self.L_Hand.Name,
    self.L_HandTip.Name,
    self.L_Thumb.Name,   

    self.R_Hip.Name,     
    self.R_Knee.Name,   
    self.R_Ankle.Name,   
    self.R_Foot.Name,

    self.L_Hip.Name,     
    self.L_Knee.Name,    
    self.L_Ankle.Name,   
    self.L_Foot.Name,

    self.Neck.Name,      
    self.Head.Name      
  }

  self.Colliders = {
    self.HeadCol,
    self.RForearmCol,
    self.LForearmCol,
    self.LKneeCol,
    self.RKneeCol,
    self.SpineCol
  }
    

  self.ColliderNames = {
    "Head",
    "R_Wrist",
    "L_Wrist",
    "L_Knee",
    "R_Knee",
    "Spine1"
  }

  if self.TargetSkeleton ~= nil then
    local targetScriptCom = self.TargetSkeleton:GetComponent(Apolloengine.Node.CT_SCRIPT);
    if targetScriptCom ~= nil then
      local skelScriptPath = "scrs:behavior/vtuber_behavior/skeleton_behavior.lua"
      for sckey, scvalue in pairs(targetScriptCom.Instances) do
        if sckey == skelScriptPath then
          self.ikSkelBehaviour = scvalue;
          break;
        end
      end      
    end
  end
  
end

function SkeletonBehavior:GetJointConfig()
  return rootBone,spineBones,bonesNames,children,bodyPair
end

function SkeletonBehavior:GetJoints()
  if self.BoneNodes == nil then
    self:Init();
  end
  return self.BoneNodes;
end

function SkeletonBehavior:GetLaplacianExtras()
  self.LaplacianExtraNodes = {
    self.headR,
    self.headL,
    self.headF,
    self.headB,
    self.bodyR,
    self.bodyL,
    self.bodyF,
    self.bodyB,
  }   
  return self.LaplacianExtraNodes;
end

function SkeletonBehavior:GetColliders()
  if self.Colliders == nil then
    self:Init();
  end
  return self.Colliders,self.ColliderNames;
end

function SkeletonBehavior:GetIKJoints()
  if self.ikSkelBehaviour ~= nil then
    return self.ikSkelBehaviour:GetJoints()
  end
  return nil;
end

SkeletonBehavior:MemberRegister(rootBone,
Venuscore.ScriptTypes.ReferenceType(
Apolloengine.Node:RTTI()
)); 

for i=1, #spineBones do
  SkeletonBehavior:MemberRegister(spineBones[i],
    Venuscore.ScriptTypes.ReferenceType(
    Apolloengine.Node:RTTI()
  )); 
end

for i=1, #bonesNames do
  SkeletonBehavior:MemberRegister(bonesNames[i],
    Venuscore.ScriptTypes.ReferenceType(
    Apolloengine.Node:RTTI()
  )); 
end

for i=1, #laplacianextras do
  SkeletonBehavior:MemberRegister(laplacianextras[i],
    Venuscore.ScriptTypes.ReferenceType(
    Apolloengine.Node:RTTI()
  )); 
end

for i=1, #colliders do
  SkeletonBehavior:MemberRegister(colliders[i],
    Venuscore.ScriptTypes.ReferenceType(
    Apolloengine.ShapeColliderComponent:RTTI()
  )); 
end


SkeletonBehavior:MemberRegister("TargetSkeleton",
    Venuscore.ScriptTypes.ReferenceType(
    Apolloengine.Node:RTTI()
));

return SkeletonBehavior;