local Object = require "classic"

local FrameCountdown = Object:extend()

function FrameCountdown:new(count)
  self.total_count = count
  self.remaining_count = 0
end

function FrameCountdown:SetCount(count)
  self.total_count = count
end

function FrameCountdown:GetCount()
  return self.total_count
end

function FrameCountdown:Start()
  self.remaining_count = self.total_count
end

function FrameCountdown:Finished()
  return self.remaining_count == 0
end

function FrameCountdown:Progress()
  return 1 - self.remaining_count / self.total_count
end

function FrameCountdown:Update()
  if self.remaining_count == 0 then
    return
  end
  self.remaining_count = self.remaining_count - 1
end

return FrameCountdown