local vc = require "venuscore"
local ae = require "apolloengine"
local mf = require "mathfunction"
local cv = require "computervisionfunction"

local FeedFaceParseRender = vc.VenusBehavior:extend("FeedFaceParseRender"); 

local dtSize = cv.GPUSegmentComponent.mlRectSize
local dtPosition = cv.GPUSegmentComponent.mlRectPosition
local dtPivot = cv.GPUSegmentComponent.mlRectPivot

function FeedFaceParseRender:new()
end

function FeedFaceParseRender:_OnUpdate(delta)
  local render = self.render
  local gpuSeg = self.Node:GetComponent(ae.Node.CT_CV_GPUSEGMENT);
  local cpuSeg = self.Node:GetComponent(ae.Node.CT_CV_SEGMENT);
  if render == nil or gpuSeg == nil then
    return
  end

  if cpuSeg ~= nil then
    local maskTex = cpuSeg:GetMask();
    local rectsize = cpuSeg:GetData(dtSize)[dtSize];
    local rectpos = cpuSeg:GetData(dtPosition)[dtPosition];
    if rectsize and rectpos then
      gpuSeg:SetRectInfo(mf.vector2(rectpos[1], rectpos[2]), mf.vector2(rectsize[1], rectsize[2]));
    else
      gpuSeg:SetRectInfo(mf.vector2(0,0), mf.vector2(0,0));
    end
    if maskTex then
      gpuSeg:SetMaskTexture(maskTex);
    end
  end

  local tex = gpuSeg:GetMask()
  local data = gpuSeg:GetData();
  local bgSize = gpuSeg:GetDetectSize()
  local texPosition = data[dtPosition];
  local texSize = data[dtSize];
  local texPivot = data[dtPivot];

  if tex and texSize and texPivot and bgSize then
    local fgRatio = mf.vector2(texSize[1] / bgSize:x(), texSize[2] / bgSize:x())
    local fgPivot = mf.vector2(texPivot[1] / texSize[1], texPivot[2] / texSize[2])
    -- WARNING(string.format(
    --   "SUNTYLOG: type=%d fgRatio=(%f, %f) fgPivot=(%f, %f)",
    --   gpuSeg.Type,
    --   fgRatio:x(),
    --   fgRatio:y(),
    --   fgPivot:x(),
    --   fgPivot:y()
    -- ))
    render:SetParameter("_FgTex", tex)
    render:SetParameter("_FgRatio", fgRatio)
    render:SetParameter("_FgPivot", fgPivot)
  end

end

FeedFaceParseRender:MemberRegister(
    "render",
    vc.ScriptTypes.ReferenceType(ae.RenderComponent:RTTI())
);

return FeedFaceParseRender;