local venuscore = require "venuscore"
local venusjson = require "venusjson"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local apollocore = require "apollocore"
local define = require "behavior.cosmetic_contact_lenses.defines"
local faceseg = require "videodecet.faceseg"
local facecnndetect = require "videodecet.facecnndetect"
local videodefined = require "videodecet.defined"
local headtarget =  require "facecute.headtarget"
local immortal =  require "facecute.immortal"
local videodecet = require "videodecet"
local detectservice = require "videodecet.mldetection"
local imageutility = require "imageutility"

local lipstick_highlight_quad_newmt = venuscore.VenusBehavior:extend("lipstick_highlight_quad_newmt");



lipstick_highlight_quad_newmt:MemberRegister("FaceDetection");
lipstick_highlight_quad_newmt:MemberRegister("HightLightPercent");
--lipstick_highlight_quad_newmt:MemberRegister("DownSampling");
lipstick_highlight_quad_newmt:MemberRegister("Threashold");
lipstick_highlight_quad_newmt:MemberRegister("reducepara");
lipstick_highlight_quad_newmt:MemberRegister("blurscale");

--删除的时候如何将识别关闭？
function lipstick_highlight_quad_newmt:new()
  if _KRATOSEDITOR or _PLATFORM_WINDOWS then
    local detectService = facecnndetect();
    detectService:SetType(videodefined.detectType.Face);
    faceseg:RegisterSeg(videodefined.detectType.Face,detectService);
    faceseg:RegisterSegJudgeFunc(videodefined.detectType.Face,self,self._NeedFaceDetect);--一定要注册
    faceseg:SetSegMark(videodefined.detectType.Face,true);
  end
  self.FaceDetection = true;
  self.HightLightPercent = 0.015;
  self.DownSampling = 2;
  self.Threashold = mathfunction.vector3(0.0,1.0,0.0);
  self.first = true;
  self.reducepara = mathfunction.vector4(0.3,0.1,0.1,0.1);
  self.blurscale = 2;
end



function lipstick_highlight_quad_newmt:_CreateTexture()
  local ts = videodecet:GetVideoFrame();  
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER); 
  self.const_mask_stream = apolloengine.TextureStream();
  local tex_size = ts:GetSize();
  local reciprocalscale = 1.0/self.DownSampling;
  tex_size = mathfunction.vector2(tex_size.mx*reciprocalscale, tex_size.my*reciprocalscale)
  self.const_mask_stream:SetStreamType(tex_size, apolloengine.TextureEntity.PF_R8G8B8);
  self.const_mask= apolloengine.TextureEntity();
  self.const_mask:PushMetadata(
  apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      self.const_mask_stream));
  self.const_mask:CreateResource();
  local firstmaterialentity = renderComponent.MaterialEntities[1];
  firstmaterialentity:SetParameter("_MainTex", self.const_mask);
end




function lipstick_highlight_quad_newmt:_OnUpdate(def)

  --self:UpdateBaseTexture();
  
  
    

  if _KRATOSEDITOR or _PLATFORM_WINDOWS then --手机端会自己set？？
    --videodecet:Update(def);--previewvideodecet增加了获取texstream接口
    faceseg:SetSegMark(videodefined.detectType.Face,self.FaceDetection);
  end

  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER); 
  if renderComponent then

    if  self.first then
      self.first = false;
      if not _KRATOSEDITOR then  --非编辑器模式初始化的话要自己setpara
          local tex = videodecet:GetVideoTexture();
          local firstmaterialentity = renderComponent.MaterialEntities[1];
          firstmaterialentity:SetParameter("_MainTex", tex);
      end
    end

    --得到嘴巴关键点
    --local size  = faceseg:GetTexSize();
    --LOG("tex size is"..size[1].." "..size[2]);
    --local count = faceseg:GetCount(videodefined.detectType.Face,0);
    --LOG("facec count is "..count);
    local points;  --返回像素坐标  以左上角为原点
    local index; --索引
    local pointsnum;
    if _KRATOSEDITOR or _PLATFORM_WINDOWS then
      points = videodecet:GetPixelFacekeypointArray();
      index = {85,86,88,90,91,101,100,99,98,97,85,97,104,103,102,101,91,92,94,96,85,91};
      pointsnum = 106;
    elseif _PLATFORM_ANDROID or _PLATFORM_IOS then
      points = videodecet:GetExtraPixelFacekeypointArray();
      index = {71,75,79,84,87,104,100,96,92,88,71,88,108,112,116,104,87,131,127,123,71,87};
      pointsnum = 134;
    end

    if points:Size() > 1 then    --points不会为nil
      
      renderComponent:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      local points_set = {};
      for i = 1,3 do
        for j = 1,#index do --pdf中的绿色点的数字是从0开始   vector2wrraywrap里面Get减去了1 取四个点 
          local point = points:Get(pointsnum*(i-1)+index[j]);
          table.insert(points_set,point:x());
          table.insert(points_set,point:y());
        end 
      end 


      local ts = videodecet:GetVideoFrame();
      if not self.const_mask or not self.const_mask_stream then
        self:_CreateTexture();
      end      
      imageutility.ImageUtility:BrightnessMap(
        ts,
        self.const_mask_stream,
        points_set, 
        self.HightLightPercent,
        self.DownSampling, 
        3, 
        self.Threashold, 
        self.reducepara, 
        self.blurscale);--0.02取2%  4缩小四倍  1 生成一张脸
        self.const_mask:ChangeTextureBuffer(self.const_mask_stream);
        local firstmaterialentity = renderComponent.MaterialEntities[1];
        firstmaterialentity:SetParameter("_MainTex", self.const_mask);
    else
      renderComponent:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    end
  end
 
end






function lipstick_highlight_quad_newmt:_OnDisable()
  faceseg:SetSegMark(videodefined.detectType.Face,false)
end

function lipstick_highlight_quad_newmt:_NeedFaceDetect()
  return true;
end


function lipstick_highlight_quad_newmt:GetDownSampling()
  return self.DownSampling;
end

function lipstick_highlight_quad_newmt:SetDownSampling(value)
  self.DownSampling = value;
  self:_CreateTexture();
end

--[[lipstick_highlight_quad_newmt:MemberRegister("DownSampling",
  venuscore.ScriptTypes.IntType(
    1, 5,
    lipstick_highlight_quad_newmt.GetDownSampling,
    lipstick_highlight_quad_newmt.SetDownSampling
));]]--



return lipstick_highlight_quad_newmt;











