local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local optimization = require "optimization"
local collisionhandler = require "avatar.retarget.collisionhandler"
local cv = require "computervisionfunction"
local util = require "behavior.avatar_behavior.util"
local skeletonnode = require "behavior.avatar_behavior.skeleton_node"
local modelpose = require "behavior.avatar_behavior.model_pose"
local skelScriptPath = "scrs:behavior/avatar_behavior/skeleton_behavior.lua"


local Avatar = modelpose:extend("Avatar"); 


function Avatar:new()
    Avatar.super.new(self);
    
    self.RootNode = nil;
    
    self.RARM= nil;
    self.RFOREARM= nil;
    self.LARM= nil;
    self.LFOREARM= nil;
    self.RLEG= nil;
    self.RFORELEG= nil;
    self.LLEG= nil;
    self.LFORELEG= nil;
    self.NECKANDHEAD= nil;
    self.BODY= nil;
    
    self.skeBehvr = nil;
    self.FixBoneLength = false;
 
end

function Avatar:_InitSkeleton()
  self.boneNodes = self.skeBehvr:GetJoints();  
  self.skeletonNode = skeletonnode();
  self.skeletonNode:SetBonesRef(self.boneNodes);
  self.skeletonNode:SetPoseEstimateBoneNames(self.skeBehvr:GetJointConfig());
  self.skeletonNode:BindPose();
end

function Avatar:_UpdateSkeleton(pos3d, cameraT,scores,cutoff)
  self.skeletonNode:UpdateSkeleton(pos3d,cameraT,scores,cutoff);
end

function Avatar:_GetSkeletonNode()
  return self.skeletonNode;
end

function Avatar:_OnAwake()

    self._isInit = false;

    local scriptCom = self.Node:GetComponent(apolloengine.Node.CT_SCRIPT);
    self.skeBehvr = scriptCom:GetScript(skelScriptPath);
    
    if self.skeBehvr == nil then
      return;
    end
    
    self:_InitSkeleton();
  
end

function Avatar:EstimateRoot(pose2d,pose3d,scores)
  local time1 = os.clock();
  if self.lastroot==nil then
      self.lastroot = {0,0,-4.3}
  end

  if self.lastroot[1]>20 or self.lastroot[2]>20 or self.lastroot[3]>20 or self.lastroot[1]<-20 or self.lastroot[2]<-20 or self.lastroot[3]<-20 then
      self.lastroot = {0,0,-4.3};
      self.RootEstimate:SetContinueWeight(0.0);
      self.RootEstimate:SetLastRootPose(mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]));
  end
  
  if self.first==false or self.first==nil  then
      self.RootEstimate:SetLastRootPose(mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]));
  end
  
  self:_UpdateSkeleton(pose3d, mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]),scores,self.cutoffscore);
  
  local time2 = os.clock();
  --LOG("EstimateRoot Cost 1:"..(time2-time1));
  
  
  local worldpose3d = {};
  for i = 1, 14 do
    worldpose3d[i] = {};
    worldpose3d[i][1] = pose3d[i][1]+self.lastroot[1];
    worldpose3d[i][2] = pose3d[i][2]+self.lastroot[2];
    worldpose3d[i][3] = pose3d[i][3]+self.lastroot[3];
  end
  --self:_GetSkeletonNode():UpdateBoneLength(worldpose3d);
  
  local modelpose3d = self:_GetSkeletonNode():GetCurrentPose();
  for i = 1, 14 do
    modelpose3d[i][1] = modelpose3d[i][1]-self.lastroot[1];
    modelpose3d[i][2] = modelpose3d[i][2]-self.lastroot[2];
    modelpose3d[i][3] = modelpose3d[i][3]-self.lastroot[3];
  end
  
      --[[
    LOG("DIFFSTART**");
    for i=1,14 do
      local diffx = modelpose3d2[i][1] - pose3d[i][1];
      local diffy = modelpose3d2[i][2] - pose3d[i][2];
      local diffz = modelpose3d2[i][3] - pose3d[i][3];
      local diffvec = mathfunction.vector3(diffx,diffy,diffz);
      LOG(diffvec);
    end
    ]]
  self.ReprojCorrect:SetTolerance(0.01);
  self.ReprojCorrect:SetMaxIterCount(10);
  self.RootEstimate:SetRootPose(mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]));
  self.RootEstimate:SetPose3D(modelpose3d);
  self.RootEstimate:SetPose2D(pose2d);
  self.lastroot = self.RootEstimate:Minimize();

  local time3 = os.clock();
  --LOG("EstimateRoot Cost 2:"..(time3-time2));
  
  return self.lastroot;
end

function Avatar:ReprojectionCorrect(pose2d,pose3d,rootpose,scores)

    self:_UpdateSkeleton(pose3d, mathfunction.vector3(rootpose[1],rootpose[2],rootpose[3]),scores,self.cutoffscore);
    
    local modelpose3d = self:_GetSkeletonNode():GetCurrentPose();
    if self.first==false or self.first==nil  then
        self.ReprojCorrect:SetLastPose3D(pose3d);
    end
    self.first = true;
    self.ReprojCorrect:SetPose3D(modelpose3d);
    self.ReprojCorrect:SetPose2D(pose2d);

    self.ReprojCorrect:SetTolerance(0.01);
    self.ReprojCorrect:SetMaxIterCount(10);
    local pose3d_ret = self.ReprojCorrect:Minimize();
    self.ReprojCorrect:SetLastPose3D(pose3d_ret);
    
    local cameraT = mathfunction.vector3(rootpose[1],rootpose[2],rootpose[3]);
    
    self:_UpdateSkeleton(pose3d_ret, cameraT,scores,self.cutoffscore);

    
    if  self.FixBoneLength==false then
      self:_GetSkeletonNode():UpdateBoneLength(pose3d_ret,scores,self.cutoffscore);
    end

    self:_GetSkeletonNode():CorrectArmsTwist();

    local modelpose3d2 = self:_GetSkeletonNode():GetCurrentPose();
    return pose3d_ret;

end

function Avatar:_OnUpdate(def)

  local pos2d, scores, pos3d =  self:GetHumanPose();
  
  
  if pos2d == nil or pos3d == nil then
    if  self.RootNode then
      self.RootNode.Active = false;
    end 
    return;
  end
  
  scores = self:SmoothScores(scores,def);
  
  
  local isLessScore = Avatar.super.IsLessScore(self);
  if self.NeedFullBody then
    if  self.RootNode and isLessScore then
      self.RootNode.Active = false;
      return;
    end 
  end
  
  if self.RootNode then
      self.RootNode.Active = true;
  end 
  
  self:_GetSkeletonNode():ResetBoneLength();
  self:_GetSkeletonNode():ResetSkeletonRotation();
  local root = self:EstimateRoot(pos2d,pos3d,scores);
  local pose3dret = self:ReprojectionCorrect(pos2d,pos3d,root,scores);
  
  self:CaculateTransforms(pose3dret,scores);
  self.super.SetCachedPoseForBluePrint(self);
  self:BodyPartVisiableChange();
end

function Avatar:BodyPartVisiableChange()
  self.bodyparts = {};
  table.insert(self.bodyparts, self.RARM);
  table.insert(self.bodyparts, self.RFOREARM); 
  table.insert(self.bodyparts, self.LARM);
  table.insert(self.bodyparts, self.LFOREARM); 
  table.insert(self.bodyparts, self.RLEG);
  table.insert(self.bodyparts, self.RFORELEG);
  table.insert(self.bodyparts, self.LLEG);
  table.insert(self.bodyparts, self.LFORELEG);
  table.insert(self.bodyparts, self.NECKANDHEAD);
  table.insert(self.bodyparts, self.BODY);
  self.bodyindex = {{1,2},{2,3},{4,5},{5,6} ,{7,8},{8,9},{10,11},{11,12},{13,13} };
  
  for i=1,#self.bodyindex do 
    if self.bodyparts[i]~= nil then
      if self.transform[self.bodyindex[i][1]].active and self.transform[self.bodyindex[i][2]].active then
        self.bodyparts[i].Active = true;
      else
        self.bodyparts[i].Active = false;
      end
    end
  end
end

function Avatar:GetEditorTransform(index)
   if _KRATOSEDITOR then
    if index == 1 then 
      local trans = self.Node:GetNodeByName("m_avg_R_Shoulder"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==2 then
      local trans = self.Node:GetNodeByName("m_avg_R_Elbow"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==3 then
      local trans = self.Node:GetNodeByName("m_avg_R_Wrist"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==4 then
      local trans = self.Node:GetNodeByName("m_avg_L_Shoulder"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==5 then
      local trans = self.Node:GetNodeByName("m_avg_L_Elbow"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==6 then
      local trans = self.Node:GetNodeByName("m_avg_L_Wrist"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==7 then 
      local trans = self.Node:GetNodeByName("m_avg_R_Hip"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==8 then
      local trans = self.Node:GetNodeByName("m_avg_R_Knee"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==9 then
      local trans = self.Node:GetNodeByName("m_avg_R_Ankle"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==10 then
      local trans = self.Node:GetNodeByName("m_avg_L_Hip"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==11 then
      local trans = self.Node:GetNodeByName("m_avg_L_Knee"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==12 then
      local trans = self.Node:GetNodeByName("m_avg_L_Ankle"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    elseif index==13 then
      local trans = self.Node:GetNodeByName("m_avg_Pelvis"):GetComponent(apolloengine.Node.CT_TRANSFORM);
      return trans:GetWorldPosition();
    else
      return mathfunction.vector3();
    end
  end
end

Avatar:MemberRegister("RootNode",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
));

Avatar:MemberRegister("RARM",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
));

Avatar:MemberRegister("RFOREARM",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
));

Avatar:MemberRegister("LARM",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
));

Avatar:MemberRegister("LFOREARM",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
));

Avatar:MemberRegister("RLEG",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
));

Avatar:MemberRegister("RFORELEG",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
));

Avatar:MemberRegister("LLEG",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
));

Avatar:MemberRegister("LFORELEG",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
));

Avatar:MemberRegister("NECKANDHEAD",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
));

Avatar:MemberRegister("BODY",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
));

Avatar:MemberRegister("camera",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.CameraComponent:RTTI()
)); 


Avatar:MemberRegister("recognition",
  venuscore.ScriptTypes.ReferenceType(
    cv.RecognitionComponent:RTTI()
)); 

Avatar:MemberRegister("scoreMin");
Avatar:MemberRegister("cutoffscore");
Avatar:MemberRegister("NeedFullBody");

Avatar:MemberRegister("FixBoneLength");

-- rigister for blueprint
Avatar:MemberRegister("pos_R_Shoulder", nil, "none");
Avatar:MemberRegister("pos_R_Elbow",    nil, "none");
Avatar:MemberRegister("pos_R_Wrist",    nil, "none");
Avatar:MemberRegister("pos_L_Shoulder", nil, "none");
Avatar:MemberRegister("pos_L_Elbow",    nil, "none");
Avatar:MemberRegister("pos_L_Wrist",    nil, "none");
Avatar:MemberRegister("pos_R_Hip",      nil, "none");
Avatar:MemberRegister("pos_R_Knee",     nil, "none");
Avatar:MemberRegister("pos_R_Ankle",    nil, "none");
Avatar:MemberRegister("pos_L_Hip",      nil, "none");
Avatar:MemberRegister("pos_L_Knee",     nil, "none");
Avatar:MemberRegister("pos_L_Ankle",    nil, "none");
Avatar:MemberRegister("pos_Pelvis",     nil, "none");
-- rigister for blueprint
Avatar:MemberRegister("rot_R_Shoulder", nil, "none");
Avatar:MemberRegister("rot_R_Elbow",    nil, "none");
Avatar:MemberRegister("rot_R_Wrist",    nil, "none");
Avatar:MemberRegister("rot_L_Shoulder", nil, "none");
Avatar:MemberRegister("rot_L_Elbow",    nil, "none");
Avatar:MemberRegister("rot_L_Wrist",    nil, "none");
Avatar:MemberRegister("rot_R_Hip",      nil, "none");
Avatar:MemberRegister("rot_R_Knee",     nil, "none");
Avatar:MemberRegister("rot_R_Ankle",    nil, "none");
Avatar:MemberRegister("rot_L_Hip",      nil, "none");
Avatar:MemberRegister("rot_L_Knee",     nil, "none");
Avatar:MemberRegister("rot_L_Ankle",    nil, "none");
Avatar:MemberRegister("rot_Pelvis",     nil, "none");
Avatar:MemberRegister("rot_Spine",      nil, "none");
Avatar:MemberRegister("rot_Neck",       nil, "none");

return Avatar;