local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local apollocore = require "apollocore"
local bundlesystem = require "venuscore.bundle.bundlesystem"

local mathfunction = require "mathfunction"
local makeup_common = require "behavior.aiface_make.ai_makeup_common"
local makeup_defined = require "behavior.aiface_make.ai_makeup_defined"
local makeup_base = require "behavior.aiface_make.ai_makeup_base"
local makeup_refobj = require "behavior.aiface_make.ai_makeup_refobj"

local contentmanager = require "apolloengine.content.contentmanager"
local cv = require "computervisionfunction"
local GCNT = 1;

local ai_makeup_mark = makeup_base:extend("ai_makeup_mark")
ai_makeup_mark.CCNT = 1;
function ai_makeup_mark:new()
  ai_makeup_mark.super.new(self);
  self.maskcamera = nil;
  self.masknode = nil;
  self.isactive = true;
  self.mask_resolution = mathfunction.vector2(200, 300);
  self.layermask = "ai_makeup_mark_mask";
  self.attach_flag = false;

end

function ai_makeup_mark:BGetRender()
  -- if nil == self.render and nil~=self.Node then
  --     self.render = self.Node:GetComponent(apolloengine.Node.CT_RENDER);
  if nil~=self.Node then
    self.render = self.Node:GetComponent(apolloengine.Node.CT_RENDER);
      if nil == self.render then
          ERROR("[ai_makeup_mark]"..makeup_common.makeup_types[self:BGetMakeupType()].key..": We Have No Render Component!")
          return nil
      end
  end
  return  self.render
end


function ai_makeup_mark:IInitialParameters()
  local renderCom = self:BGetRender();
  if renderCom then
    self:SetupMaskScene();
    self.attach_flag = false;
  else
    LOG("[ai_makeup_mark]: No rendercomponent found!")
    return false  
  end
  return true
end

-- 更新参数
function ai_makeup_mark:IUpdateParameters()
  local renderCom = self:BGetRender();
  if renderCom then
    self:UpdateRenderParams();
  else
    LOG("[ai_makeup_mark]: No rendercomponent found!")
    return false  
  end
  return true
end


-- 销毁资源
function makeup_base:IDestroy()
  -- 清理全局mask资源,释放后置为nil
  if self.maskcamera and self.maskcamera:ReleaseReference() then
    apollocore.SceneManager.makeup_maskcam = nil;
  end

  if self.masknode and self.masknode:ReleaseReference() then
    local makeupType = self:BGetMakeupType();
    if makeupType == makeup_common.IRIS_LEFT then
      apollocore.SceneManager.makeup_mark_irisL = nil;
    elseif makeupType == makeup_common.IRIS_RIGHT then
      apollocore.SceneManager.makeup_mark_irisR = nil;
    end
  end
  
  self.maskRT = nil;
  self.maskcamera = nil;
  self.masknode = nil;
  return true
end

function ai_makeup_mark:fileExists(path)
  local file = io.open(path, "rb")
  if file then file:close() end
  return file ~= nil
end

-- 加载fbo，若没有则创建
function ai_makeup_mark:InitRenderTargetByPath(rt, path)
  local fboPath = venuscore.IFileSystem:PathAssembly(path);
  if self:fileExists(fboPath) == false then
    LOG("[ai_makeup_mark]: No fbo file found in "..fboPath);
    return;
    --fbotool:CreateFbo(fboPath);
  end
  rt:PushMetadata(apolloengine.RenderTargetFileMetadata(fboPath));
  rt:CreateResource();
end

-- 加载mat文件，若没有则创建
function ai_makeup_mark:InitMaterialByPath(path, materialPath)
  local matpath = venuscore.IFileSystem:PathAssembly(path);
  -- local firstCreate = false;
  if self:fileExists(matpath) == false then
    LOG("[ai_makeup_mark]: No mat file found in "..matpath);
    return;
  --   local dirpath = string.match(matpath, "(.+)/[^/]*%.%w+$");
  --   os.execute('mkdir -p \"' .. dirpath .. '\"')
  --   mattool:CreateMat(venuscore.IFileSystem:PathAssembly(matpath));
  --   firstCreate = true;
  end

  local meta = apolloengine.MaterialMetadata(matpath);
  local sceneid = self.Node:GetHostScene():GetStaticID();
  meta:SetSceneID(sceneid);
  local materialEntity = apolloengine.MaterialEntity();
  materialEntity:PushMetadata(meta);
  materialEntity:CreateResource();

  -- if firstCreate == true then
  --   materialEntity:ChangeShaderPath(venuscore.IFileSystem:PathAssembly(materialPath));
  --   matsetting.SaveOneMat(materialEntity, materialPath)
  -- end
  return materialEntity
end

-- 设置材质参数的接口
function ai_makeup_mark:SetParameter(key, value)
  local render = self:BGetRender();
  local materialEntity = render.MaterialEntities[1];
  materialEntity:SetParameter(key, value);
end


function ai_makeup_mark:CreateMaskNode(scene, path)
  -- prefab方式创建mesh
  local prefab_path = venuscore.IFileSystem:PathAssembly(path);
  --local file = io.open(prefab_path, "rb");
  --local bufferStr = file:read("*a");
  local _,nodes = bundlesystem:DeserializeFromPath(prefab_path,bundlesystem.DeserializeMode.Scene,scene);
  --local nodes = bundlesystem:DeSerialize(bufferStr, scene, bundlesystem.DeserializeMode.Prefab);
  --local _,nodes = bundlesystem:
  masknode = nodes[1];
  return masknode;
end


function ai_makeup_mark:CreateMaskCam(scene, editormode)
  -- 创建mask camera
  local camera = scene:CreateGenericNode();
  camera:SetName("camera_mask");
  maskcam = camera:CreateComponent(apolloengine.Node.CT_CAMERA);
  local near = 0.1;
  local far = 100;
  local pos = mathfunction.vector3(0,0,1);
  local resolution = mathfunction.vector2(720,1280);
  local lookat = mathfunction.vector3(0,0,0);
  local up = mathfunction.vector3(0,1,0);

  maskcam:SetSequence(makeup_defined.mask_sequence);
  maskcam:FixedResolution(resolution);
  maskcam:SetLayerMaskNothing();
  maskcam:CreatePerspectiveProjection(near,far);
  maskcam:LookAt(pos, lookat, up);
  maskcam:Recalculate();
  maskcam:Activate();
  maskcam:SetClearColor(mathfunction.Color(0.0, 0.0, 0.0, 1.0));
  
  return camera;
end

function ai_makeup_mark:InitMaskScene(prefab_path, matpath, masktex_path, eyemask_type)
  local scene = self.Node:GetHostScene();

  -- 相机全局只有一个
  if apollocore.SceneManager.makeup_maskcam == nil or self.CCNT ~= GCNT then
    local maskcamnode = self:CreateMaskCam(scene);
    -- if _KRATOSEDITOR then
    --   maskcamnode.EditorUIType = apollocore.IContent.UNVISUAL;
    -- end
    apollocore.SceneManager.makeup_maskcam = makeup_refobj:new(scene, maskcamnode);
    GCNT = CCNT;
  end
    
  local masknode = self:CreateMaskNode(scene, prefab_path);
  -- if _KRATOSEDITOR then
  --   masknode.EditorUIType = apollocore.IContent.UNVISUAL;
  -- end
  local material = self:InitMaterialByPath(matpath, "comm:documents/editor_shaders/makeup/makeup_mask.material");
  local makeup_type_value = self:BGetMakeupType()
  local mask_position = makeup_common.makeup_uv_offset[eyemask_type - 1][1]
  local mask_size = makeup_common.makeup_uv_offset[eyemask_type - 1][2]
  material:SetParameter("_MaskInfo",mathfunction.vector4(
        mask_position[1],mask_position[2],mask_size[1],mask_size[2]))
  local noderender = masknode:GetComponent(apolloengine.Node.CT_RENDER);
  if noderender then
    noderender:ChangeMaterial(material, 1);
    local tex = apollocore.TextureEntity();
    tex:PushMetadata(apollocore.TextureFileMetadata(
            apollocore.TextureEntity.TU_STATIC,
            apollocore.TextureEntity.PF_AUTO,1, false,
            apollocore.TextureEntity.TW_CLAMP_TO_EDGE,
            apollocore.TextureEntity.TW_CLAMP_TO_EDGE,
            apollocore.TextureEntity.TF_LINEAR,
            apollocore.TextureEntity.TF_LINEAR,
            masktex_path));
    tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
    tex:CreateResource();
    material:SetParameter("_MainTex", tex);
  else
    LOG("[ai_makeup_mark]: Create mask prefab failed");
  end


  return masknode;
end

function ai_makeup_mark:SetupMaskScene()
  -- 判断是否为editorscene，加载不同设置
  local editormode = false;
  if _KRATOSEDITOR then
    local editsceneID = apollocore.SceneManager:GetEditSceneID()
    local gamescene = apollocore.SceneManager:GetPreviewScene();
    local gamesceneID = nil;
    if gamescene then
      gamesceneID = gamescene:GetStaticID();
    end
    local currentsceneID = self.Node:GetHostScene():GetStaticID();

    if currentsceneID == editsceneID then
      editormode = true;
    end
  end

  self.editormode = editormode;

  if editormode == true then
    --不处理 editor 模式
   return;
  end

  -- lips直接使用识别得到的mask，iris则由程序来画
  local makeupType = self:BGetMakeupType();
  if makeupType == makeup_common.LIPS then

  elseif makeupType == makeup_common.IRIS_LEFT then
    self.maskRT = apolloengine.RenderTargetEntity();
    self:InitRenderTargetByPath(self.maskRT, makeup_defined.maskfbo_path);
    local matpath = makeup_defined.iris_left.mat_path;
    local prefab_path = makeup_defined.iris_left.prefab_path;
    local maskparams = makeup_defined.iris_left.mask_params;
    self.layermask = makeup_defined.layermask;
    -- if apollocore.SceneManager.makeup_mark_irisL==nil then
    local masknode = self:InitMaskScene(prefab_path, matpath, maskparams.mask_texture, maskparams.eyemask_type);
    apollocore.SceneManager.makeup_mark_irisL = makeup_refobj:new(self.Node:GetHostScene(), masknode);
    -- end
    self.masknode = apollocore.SceneManager.makeup_mark_irisL;
    self.maskcamera = apollocore.SceneManager.makeup_maskcam;
    self.masknode:GetReference();
    self.maskcamera:GetReference();
    self:ConnectMaskCamAndNode(editormode);
  elseif makeupType == makeup_common.IRIS_RIGHT then
    self.maskRT = apolloengine.RenderTargetEntity();
    self:InitRenderTargetByPath(self.maskRT, makeup_defined.maskfbo_path);
    local matpath = makeup_defined.iris_right.mat_path;
    local prefab_path = makeup_defined.iris_right.prefab_path;
    local maskparams = makeup_defined.iris_right.mask_params;
    self.layermask = makeup_defined.layermask;
    -- if apollocore.SceneManager.makeup_mark_irisR==nil then
    local masknode = self:InitMaskScene(prefab_path, matpath, maskparams.mask_texture, maskparams.eyemask_type);
    apollocore.SceneManager.makeup_mark_irisR = makeup_refobj:new(self.Node:GetHostScene(), masknode);
    -- end
    self.masknode = apollocore.SceneManager.makeup_mark_irisR;
    self.maskcamera = apollocore.SceneManager.makeup_maskcam;
    self.masknode:GetReference();
    self.maskcamera:GetReference();
    self:ConnectMaskCamAndNode(editormode);
  end

end


function ai_makeup_mark:ConnectMaskCamAndNode(editormode)
  local iseditor = editormode or false;
  if iseditor==true then
    return;
  else
    if self.maskcamera and self.maskRT then
      local camcomponent = self.maskcamera:GetRefObj():GetComponent(apolloengine.Node.CT_CAMERA);
      camcomponent:AttachRenderTarget(self.maskRT);
      camcomponent:AddLayerMask(self.layermask);
      if self.masknode ~= nil then
        self.masknode:GetRefObj():SetLayer(camcomponent.LayerMask);
      end
    end
  end
end


function ai_makeup_mark:UpdateRenderParams()
  if nil ~= self.maskRT then
    self:SetParameter("_MaskMap", self.maskRT);
  end
  
end

function ai_makeup_mark:_OnLateUpdate(def)
  if self.hasInit then
    self:BUpdateFaceData()
    if self.recognition ~= nil and  self.faceMeshType ~= nil then
    -- if false then
      if not self.attach_flag then
        if self.maskcamera and self.maskRT then
          local parentnode = self.Node:GetRoot();
          parentnode:AttachNode(self.maskcamera:GetRefObj());
     
          if self.masknode ~= nil then
            parentnode:AttachNode(self.masknode:GetRefObj());
          end
        end
        self.attach_flag = true;
      end   
      self:IUpdateParameters()
      cv.AIFaceUtility:UpdateMakeupVertex(self.recognition, self.render, self.faceMeshType, self:BGetFaceID())
    end
  else
    self:BInitialParameters();
  end
end 





return ai_makeup_mark