local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
require "utility"
require "venusdebug"

local mean3d =   {19.2636853 , -364.07221957,  -49.70211423,
                  27.16492364, -196.40941273,  -20.37640802,
                  22.19212815, -141.56468872,   -5.60397339,
                  -5.58979448, -364.93143521,  -55.38263611,
                 -20.33558863, -190.03006973,  -28.19176664,
                 -20.35292413, -128.4411834 ,  -11.07210294,
                10.95295143, -3.93221042,  2.62632808,
                -0.295091466,  297.266238,  65.4302828,
                 -6.60301005, 595.80278792, 104.0461003 ,
                -10.95295143,   3.93221042,  -2.62632808,
                -27.20607717, 304.02601631,  60.93665227,
                -29.8390817 , 601.00520868, 101.34394339,
                   7.82560758, -399.63497744,  -57.41391151,
                  11.73082648, -614.31339237,  -84.39472289}
                
                
local  std3d =    {165.61815005, 128.59831801, 177.02192118,
                   250.74411554, 190.4404165 , 248.59888738,
                   293.07497601, 296.80384374, 289.69961481,
                   168.92396867, 134.27708876, 179.31947835,
                   247.40264662, 187.61003002, 247.06318987,
                   286.40234624, 285.69366664, 290.44794477,
                   88.80125935, 29.06297271,    81.58489786,
                   217.54632543, 241.31781421, 227.17140183,
                   262.61936067, 322.53261843, 292.94816938,
                   88.80125935, 29.06297271,   81.58489786,
                   208.94766691, 235.99653981, 232.40474048,
                   264.9637643 , 316.55532318, 299.10806233,
                   146.69068404, 135.82975555, 165.10515741,
                   221.59899471, 193.711728  , 247.66506011}


local vnectdection = {}

function vnectdection:Initialize(modelpath, video_path)
  self.frameidx = 1;
  self.pose3d = venusjson.LaodJsonFile(video_path.."kp_3d.json");
  self.pose2d = venusjson.LaodJsonFile(video_path.."kp_2d.json");
  self.fid2d = venusjson.LaodJsonFile(video_path.."fid_2d.json");
  --self.pose2d = venusjson.LaodJsonFile("comm:documents/bodyvnect/2d.json");
  self.totallength = # self.pose3d
  self.scores = {}
  self.time = 0;
end

local pos3dtosave = {}
local pos2dtosave = {}
local scoretosave = {}

function vnectdection:Estimate(rgbtexture)
  local cur3d = self:tbl_copy( self.pose3d[self.frameidx]);
  for i=1, #cur3d do
    cur3d[i][1] = cur3d[i][1];
    cur3d[i][2] = cur3d[i][2];
    cur3d[i][3] = cur3d[i][3];
  end
  cur3d[15] = nil;
  local cur2d = self:tbl_copy( self.pose2d[self.frameidx]);
  local curScore = self:tbl_copy( self.fid2d[self.frameidx]);
  
  self.frameidx = self.frameidx+1;
  
  if self.frameidx>self.totallength then
    self.frameidx = 1;
  end

  return cur2d,cur3d,curScore;
end

function vnectdection:tbl_copy(orig)
    local orig_type = type(orig)
    local copy
    if orig_type == "table" then
        copy = {}
        for orig_key, orig_value in next, orig, nil do
            copy[self:tbl_copy(orig_key)] = self:tbl_copy(orig_value)
        end
    else -- number, string, boolean, etc
        copy = orig
    end
    return copy
end

return vnectdection;