local ae = require "apolloengine"
require "utility"

local preloadservice = {}

function preloadservice:Loading()
  LOG("preloading materials");
  ae.IMaterialSystem:Preloading("comm:documents/material/simple.material");
  ae.IMaterialSystem:Preloading("comm:documents/material/nl_simple_nt.material");
  
  self:LoadOutLine();
  self:LoadMlaa();
  
  
end

function preloadservice:LoadOutLine()
  local apolloengine = ae;
  apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"INTERNAL_COLOR0");
  local color = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"Main_Color");
  local width = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"EDGE_WIDTH");
  local offscale = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"OFFSET_SCALE");
  local minwidth = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MIN_WIDTH");
  local rangedis = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"RANGE_DISTANCE");
  ae.IMaterialSystem:Preloading("comm:documents/material/nl_4bmatrixoutline.material");
  ae.IMaterialSystem:Preloading("comm:documents/material/simpleoutline.material");
end

function preloadservice:LoadMlaa()
    local apolloengine = ae;
  apolloengine.ShaderEntity.TEXTURE_DIFFUSE_POINT =
  apolloengine.IMaterialSystem:NewParameterSlot(
     apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_DIFFUSE_POINT");
  apolloengine.ShaderEntity.TEXTURE_NEIGHBOR_BLEND =
    apolloengine.IMaterialSystem:NewParameterSlot(
     apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_NEIGHBOR_BLEND");
    
  apolloengine.ShaderEntity.TEXTURE_AREAMAP =
  apolloengine.IMaterialSystem:NewParameterSlot(
     apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_AREAMAP");  

  apolloengine.ShaderEntity.PIXEL_SIZE =     apolloengine.IMaterialSystem:NewParameterSlot(
     apolloengine.ShaderEntity.UNIFORM,
      "PIXEL_SIZE"); 
    
  ae.IMaterialSystem:Preloading("comm:documents/material/edgedetection.material");
  ae.IMaterialSystem:Preloading("comm:documents/material/blendweight.material");
  ae.IMaterialSystem:Preloading("comm:documents/material/simplegamma.material");
  ae.IMaterialSystem:Preloading("comm:documents/material/neighborblend.material");
    


end


return preloadservice;