#include "functions/util.function"
#SHADER_DEFINE DirmapVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
       
	}
	FUNCTION_OUTPUT =
	{
        { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;  
    vec2 out_TexCooridate;
    out_TexCooridate= in_TexCoordinate.xy;     // upper left corner
 
#END_CODE

#END_DEFINE


#SHADER_DEFINE DirmapFragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_Lab,		    	NONE,	TEXTURE2D,	  "Lab" },
        { ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,	"vUV"},
		{ UNIFORM_uOs,				HIGH,	VEC2,	"uOs"},
        { UNIFORM_uVer,            MEDIUM, FLOAT,   "uVer"}
	}
  
#SHADER_CODE

	vec3 m01 = texture2D(Lab, vUV + uOs * vec2(-1., +0.)).rgb;
    vec3 m10 = texture2D(Lab, vUV + uOs * vec2(+0., -1.)).rgb;
    vec3 m12 = texture2D(Lab, vUV + uOs * vec2(+0., +1.)).rgb;
    vec3 m21 = texture2D(Lab, vUV + uOs * vec2(+1., +0.)).rgb;

    vec3 dx = (m21 - m01);
    vec3 dy = (m12 - m10);

    highp float E;
    highp float F;
    highp float G;

    dx *= 100.0;
    dy *= 100.0;
     E = dot(dx, dx);
     F = dot(dx, dy);
     G = dot(dy, dy);
    highp float gof = ( E + G + sqrt(fsqr(E - G) + 4.0 * F * F) ) / 2.0;
    vec2 v1 = vec2(gof - E, - F);
    if (length(v1) < 0.005) v1 = vec2(0.0, 1.0);
    gl_FragColor = encode(v1);
    //gl_FragColor = vec4(v1.r,0.0,0.0,1.0);
 
#END_CODE

#END_DEFINE