#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "transfer3"
RenderQueue = "Opaque+100"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF}
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"


struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 screenPosition : TEXCOORD1;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	float4x4 in_Transfrom = LOCALWORLD_TRANSFORM;
	float4x4 in_ViewPorj = CAMERA_VIEWPROJ;
	float4 in_Position = v.in_Position.xyzw;
	float2 in_Coordinate = v.in_Coordinate.xy;

	float4 in_ScreenPosition = ObjectToClipPos(v.in_Position);
	float4 new_Coordinate = ObjectToClipPos(float4(in_Coordinate, 0.0, 1.0));
	new_Coordinate.y = -new_Coordinate.y;
	float2 out_Coordinate = (new_Coordinate.xy / new_Coordinate.w + float2(1.0,1.0)) / 2.0;
	o.vertex = UniformNDC(in_ScreenPosition);
    o.out_Coordinate = out_Coordinate;
	return o;
}

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	half2 in_Coordinate = i.out_Coordinate;

    clamp(in_Coordinate, 0.0, 1.0);
	mainColor = float4(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, in_Coordinate.xy).rgb, 1.0);
}

ENDCG
#END