
#DEFPARAMS
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
TEXTURE_BACKG = { "Background Tex", TEXTURE2D, "white" },
TEXTURE_LUT = { "Lut Tex", TEXTURE2D, "white" },
UNIFORM_FACETEXPARA = { "FaceTex Params", VEC4, "1.0,1.0,0.0,0.0"},
UNIFORM_ALPHACOF = { "Alpha Cofactor", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "facechangelut"
RenderQueue = "Opaque+100"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE}
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float2 uvstd : TEXCOORD2;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 texCoord : TEXCOORD0;
	float2 texCoordBag : TEXCOORD1;
	float2 texCoordStd : TEXCOORD2;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_BACKG;
Texture2D TEXTURE_LUT;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_BACKG_Sampler;
SamplerState TEXTURE_LUT_Sampler;
float4 UNIFORM_FACETEXPARA;
float UNIFORM_ALPHACOF;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.texCoord = v.uv;
	float2 flipVertex = float2(v.vertex.x, -v.vertex.y);
	o.texCoordBag = (float2(1.0, 1.0) + flipVertex) / 2.0;
	o.texCoordStd = v.uvstd * float2(UNIFORM_FACETEXPARA.x, UNIFORM_FACETEXPARA.y)
								+ float2(UNIFORM_FACETEXPARA.z, UNIFORM_FACETEXPARA.w);
	return o;
}

float4 LUT_mini(in float4 textureColor, in Texture2D lookupTable, in SamplerState texsampler) 
{
    float blueColor = textureColor.b * 15.0;

    float2 quad1;
    quad1.y = floor(floor(blueColor) / 4.0);
    quad1.x = floor(blueColor) - (quad1.y * 4.0);

    float2 quad2;
    quad2.y = floor(ceil(blueColor) / 4.0);
    quad2.x = ceil(blueColor) - (quad2.y * 4.0);

    float2 texPos1;
    texPos1.x = (quad1.x * 0.25) + 0.0078125 + (0.234375 * textureColor.r);
    texPos1.y = (quad1.y * 0.25) + 0.0078125 + (0.234375 * textureColor.g);


    float2 texPos2;
    texPos2.x = (quad2.x * 0.25) + 0.0078125 + (0.234375 * textureColor.r);
    texPos2.y = (quad2.y * 0.25) + 0.0078125 + (0.234375 * textureColor.g);

    float4 newColor1 = lookupTable.Sample(texsampler, float2(texPos1.x,1.0-texPos1.y));
    float4 newColor2 = lookupTable.Sample(texsampler, float2(texPos2.x,1.0-texPos2.y));

    float4 newColor = lerp(newColor1, newColor2, frac(blueColor));
    return newColor;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float4 baseColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.texCoordBag);
	float4 blendColor = TEXTURE_BACKG.Sample(TEXTURE_BACKG_Sampler, i.texCoordStd);
	baseColor = float4(clamp(baseColor.rgb,0.0,0.9), baseColor.a);
    float4 newColor = LUT_mini(baseColor, TEXTURE_LUT, TEXTURE_LUT_Sampler);
	mainColor = float4(newColor.rgb, blendColor.a*UNIFORM_ALPHACOF);
}
ENDCG
#END
