package com.amazon.discovery;

import com.amazon.discovery.testdiscoverables.MyTestDiscoverableImpl1;
import com.amazon.discovery.testinterfaces.MyTestDiscoverableContract;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

/**
 * Unit tests for {@link DiscoveryLoader}
 * Copyright © 2018 Amazon.com. All Rights Reserved.
 * @author jacobc
 */
@RunWith(PowerMockRunner.class)
@PrepareForTest({DiscoveryLoader.class, DiscoveryProvider.class})
public class DiscoveryLoaderTest {

    @Test
    public void testSetAlternateMappingProvider() {
        final String testDiscovery = "{\"discovery\": [{\n" +
                "    \"contract\": \"com.amazon.discovery.testinterfaces.MyTestDiscoverableContract\",\n" +
                "    \"implementations\": [\n" +
                "        \"com.amazon.discovery.testdiscoverables.MyTestDiscoverableImpl1\"\n" +
                "    ]\n" +
                "}]}";
        final DiscoveryLoader.InputStreamProvider testProvider = Mockito.spy(
                new DiscoveryLoader.InputStreamProvider() {
            @Override
            public InputStream getInputStream() {
                return new ByteArrayInputStream(testDiscovery.getBytes(StandardCharsets.UTF_8));
            }
        });
        final DiscoveryLoader.InputStreamProvider oldProvider =
                DiscoveryLoader.replaceInputStreamProvider(testProvider);

        // Reset the discovery provider, so that the next access will re-create it and use our stream provider.
        Discovery.resetDiscoveryProvider();
        UniqueDiscovery<MyTestDiscoverableContract> discoverable =
                UniqueDiscovery.of(MyTestDiscoverableContract.class);
        Assert.assertNotNull(discoverable.value());
        Assert.assertTrue(discoverable.value() instanceof MyTestDiscoverableImpl1);
        Mockito.verify(testProvider, Mockito.times(1)).getInputStream();
        DiscoveryLoader.replaceInputStreamProvider(oldProvider);
    }

}
