/**
 * Discovery Framework Client APIs.
 * <p>
 * This is the API package for the marker interface: {@link com.amazon.discovery.Discoverable}.
 * To make a class discoverable, one should do the following:
 * <ul>
 *     <li>must implement a public interface</li>
 *     <li>must implement {@link com.amazon.discovery.Discoverable}</li>
 *     <li>must have a public default constructor</li>
 * </ul>
 *
 * Sample code:
 * <pre>
 *    public class MyContractImpl implements MyContract, Discoverable {
 *
 *        //public default constructor
 *        public MyContractImpl() {
 *            //...
 *        }
 *
 *        //... implementation
 *    }
 * </pre>
 *
 * <p>
 * This package also contains APIs for consumer to discover classes via
 * {@link com.amazon.discovery.Discoveries} or
 * {@link com.amazon.discovery.UniqueDiscovery}.
 * <p>
 *
 * Sample code:
 * <pre>
 *    //access a set of implementations of a given contract:
 *    Discoveries&lt;MyContract&gt; discoverables =  Discoveries.of(MyContract.class);
 *    for (MyContract discoverable : discoverables) {
 *        //use the discoverable.
 *    }
 *
 *    //or use the unique singleton instance.
 *    UniqueDiscovery&lt;MyContract&gt; myComponent = UniqueDiscovery.of(MyContract.class);
 *    MyContract discoverable = myComponent.value();
 *    if (discoverable != null) {
 *      //use the discoverable
 *    }
 *
 * </pre>
 * Created by Ma, Don on 04/13/2018.<br>
 * Copyright © 2018 Amazon.com. All Rights Reserved.
 */
package com.amazon.discovery;
