package com.amazon.discovery;

/**
 * Marker interface for components that will be discoverable.
 * <p>
 * To make a component discoverable, one should do the following:
 * <ul>
 *     <li>must implement a public component interface</li>
 *     <li>must implement {@link Discoverable}</li>
 *     <li>must have a public default constructor</li>
 * </ul>
 *
 * Sample code:
 * <pre>
 *    public class MyContractImpl implements MyContract, Discoverable {
 *
 *        //public default constructor
 *        public MyContractImpl() {
 *            //...
 *        }
 *
 *        //... implementation
 *    }
 * </pre>
 *
 * Created by Ma, Don on 04/13/2018.<br>
 * Copyright © 2018 Amazon.com. All Rights Reserved.
 */
public interface Discoverable {
}
