package com.amazon.discovery;

import javax.annotation.Nonnull;

/**
 * Definition of a dependency that needs to be injected into a Discoverable's constructor.
 */
final class Dependency {
    /**
     * The dependency type.
     */
    @Nonnull
    private final DependencyType type;
    /**
     * The requested class name.
     */
    @Nonnull
    private final Class requestedClass;

    /**
     * Constructor.
     * @param type the dependency type (required, optional, plural discoveries)
     * @param requestedClass the requested class
     */
    Dependency(@Nonnull final DependencyType type, @Nonnull final Class requestedClass) {
        this.type = type;
        this.requestedClass = requestedClass;
    }

    /**
     * @return dependency type
     */
    @Nonnull
    DependencyType getType() {
        return type;
    }

    /**
     * @return requested class
     */
    @Nonnull
    Class getRequestedClass() {
        return requestedClass;
    }
}
