local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
require "venusdebug"
require "utility"



local main = {}

function main:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;
  
  self.cumtime = self.cumtime + def;
  self.fps = self.fps + 1;
  
  if self.cumtime > 5 then
    local fps = self.fps / self.cumtime;
    self.fps = 0;
    self.cumtime = 0;
    LOG("FPS "..fps);
  end
  return def;
end


function main:CreateCameras(near, far, pos, lookat, up)  
  self.maincamera = apollonode.CameraNode();--新建摄像机
	self.maincamera:CreatePerspectiveProjection(near, far);--设置摄像机
	self.maincamera:LookAt(pos, lookat, up);
  self.maincamera:Activate();--激活主摄像机
  
  self.rendertarget = apolloengine.RenderTargetEntity();--创建一个FBO
  self.rendertarget:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_A,--标记作用，主要用于底层资源共享
      mathfunction.vector4(0.5,0.5,0.5,1),--清屏颜色
      apolloengine.Framework:GetViewport(),--视口大小
      apolloengine.Framework:GetResolution()));--分辨率
  self.outputtexture = self.rendertarget:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  self.outputtexture:PushMetadata(--创建纹理
				apolloengine.TextureBufferMetadata(apolloengine.Framework:GetResolution()));
  self.rendertarget:CreateResource();
  
    --创建一个渲染到rt的摄像机
  self.outputcamera = apollonode.CameraNode();
	self.outputcamera:CreatePerspectiveProjection(near, far);
	self.outputcamera:LookAt(pos, lookat, up);
  self.outputcamera:AttachRenderTarget(self.rendertarget);
  --self.outputcamera:EraseLayerMask(apolloengine.LayerMask.MC_MASK_DEFAULT_LAYER);--设置渲染mask
  self.outputcamera:SetSequence(
    self.maincamera:GetSequence() + 1);--将渲染摄像机的顺序设置为主摄像机之后渲染
  self.texturestream = apolloengine.TextureStream();
end

function main:_CreateSpine()
  self.spine = apollonode.SpineNode();
  self.spine:CreateResource(
    "docs:spinedemo/spineboy.atlas",
    "docs:spinedemo/spineboy-ess.skel",
    "comm:documents/material/spine_noraml.material")
  self.spine:SetLocalPosition(mathfunction.vector3(150, -480, 0));
  self.spine:SetLocalScale(mathfunction.vector3(0.5, 0.5, 0));
  self.spine:PushAnimation("run", true, 0.0);--更新位置需要执行一阵update
  self.bone = self.spine:FindBone("gun");
  
  self.spine2 = apollonode.SpineNode();
  self.spine2:CreateResource(
    "docs:spinedemo/spineboy.atlas",
    "docs:spinedemo/spineboy-ess.skel",
    "comm:documents/material/spine_noraml.material")
  self.spine2:SetLocalPosition(mathfunction.vector3(-150, -480, 0));
  self.spine2:SetLocalScale(mathfunction.vector3(0.5, 0.5, 0));
  self.spine2:PushAnimation("idle", true, 0.0);--更新位置需要执行一阵update
end

function main:Initialize()
  _COROUTINES_ON();
  
  self:CreateCameras(1, 1000,
    mathfunction.vector3(0,0,1),
		mathfunction.vector3(0,0,0),
		mathfunction.vector3(0,1,0));
  apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "Update");
  
  apolloengine.Framework:AddTouchCallback(self._Agent, "OnTouch");

  self:_CreateSpine();

  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.cumtime = 0;
  self.fps = 0;
  LOG("initialize done");
  _COROUTINES_OFF();
  return true;
end

function main:Update()
  local diff = self:Timespan();
  if self.spine then
    self.spine:UpdateAnimation(diff);
  end  
  if self.spine2 then
    self.spine2:UpdateAnimation(diff);
  end 
end

function main:OnTouch(touchinfo)
  _COROUTINES_ON();
  local c = touchinfo:GetPointCount();
  for i=1, c do
  local tt = touchinfo:GetTouchType(i);
    if apolloengine.TouchInfo.TT_PRESS == tt then
      if self.spine then
        self.spine = nil;
        collectgarbage();
      else
        self:_CreateSpine();
      end  
    end    
  end  
  _COROUTINES_OFF();
end

function main:Abort()
  apolloengine.Framework:RemoveSynchronizeUpdateCallback(self._Agent, "Update");
  venuscore.IApplication:Abort();
end


return main;