
local SquareInfo = require "photomood.squareinfo";
local stringsplit = require "stringsplit"
local likeapp = require "likeapp"

--每一行代表一帧
--一帧包含四边形的四个顶点，空格分开
local keypointcount = 4;


local paserservice = {}

function paserservice:Initialize()
  self.keypoint_path = {};
  self.keypoint_size = {};
  self.keypoint_id = {};
  return true;
end

function paserservice:GetKeyPointCount()
  return keypointcount;
end


function paserservice:AddKeypointFile(i,fullpath,size)
  table.insert(self.keypoint_path,fullpath);
  table.insert(self.keypoint_size,size);
  table.insert(self.keypoint_id,i);
  return true;
end

function paserservice:GetTestData()
  return self.keypoint_path;
end



function paserservice:PaserFile(agent, index)
  --把所有文件打开
  local path_cnt = #self.keypoint_path;
  local valid_file_iterators = {};
  local valid_file_res_size = {};
  local valid_file_handles = {};
  local valid_file_fullpath = {};
  local valid_file_row_index = {}; --记录行号，方便调试
  local valid_file_object_id = {};
  for i = 1, path_cnt do
    local fullpath = self.keypoint_path[i];
    local file = io.open(fullpath, "rb")
    --if file then
      --table.insert(valid_file_handles,file);
      table.insert(valid_file_iterators,io.lines(fullpath));  --保存所有有效文件的迭代器
      table.insert(valid_file_res_size,self.keypoint_size[i]);
      table.insert(valid_file_fullpath,self.keypoint_path[i]);
      table.insert(valid_file_row_index,1);
      table.insert(valid_file_object_id,self.keypoint_id[i]);
      --file:close();
    --end
  end
  
  --循环所有文件每次读取一行
  --恶心的代码
  --
  for j = 0, 500 do  --简单期间，假设文件不超过500行
    for i = 1, #valid_file_iterators do
      local file_iterator = valid_file_iterators[i];
      if file_iterator ~= nil then
        local k,v = file_iterator();
        if k ~= nil then
          local data = stringsplit(k, "%s", tonumber);
          local square_coordinate_count = #data;
          if square_coordinate_count ~= 8 then
            LOG("Data file fullpath is: " .. valid_file_fullpath[i]);
            LOG("Number count is: " .. tostring(square_coordinate_count));
            LOG("Keypoint data error! Line number: " .. tostring(valid_file_row_index[i]));  --关键点数据不对
            LOG("Line content is: " .. tostring(line));
          else
            local squareinfo = SquareInfo(valid_file_res_size[i]);
            valid_file_row_index[i] = valid_file_row_index[i] + 1;
            squareinfo:PushSquare(data[1],data[2],data[3],data[4],data[5],data[6],data[7],data[8]);
            agent:CallbackFunction(index, squareinfo,valid_file_object_id[i]); --得到了一帧关键点
          end
        else
          --此时文件会被关闭
          valid_file_iterators[i] = nil;
        end
      end
    end
  end
end

  
  
  


--[[
function paserservice:PaserFile(agent, index, fullpath, size, id,splitInfo)  

  local file = io.open(fullpath, "rb")
  if file then
    file:close();
  end
  if file ~= nil then
    local index_ = 1;
    for line in io.lines(fullpath) do
      local data = stringsplit(line, "%s", tonumber);
      local square_coordinate_count = #data;
      if square_coordinate_count ~= 8 then
        LOG("Data file fullpath is: " .. fullpath);
        LOG("Number count is: " .. tostring(square_coordinate_count));
        LOG("Keypoint data error! Line number: " .. tostring(index_));  --关键点数据不对
        LOG("Line content is: " .. tostring(line));
      else
        local squareinfo = SquareInfo(size,splitInfo);
        squareinfo:SetID(id);
        index_ = index_ + 1;
        squareinfo:PushSquare(data[1],data[2],data[3],data[4],data[5],data[6],data[7],data[8]);
        agent:CallbackFunction(index, squareinfo); --得到了一帧关键点
      end
    end
  else
    ERROR(fullpath .. " do not exist!");
    likeapp.AI:OnCallback(0,fullpath .. " do not exist!");
  end
end
--]]
return paserservice;