
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local MaskSequenceBase = require "photomood.mask_sequence_base"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local biugodefined = require "photomood.defined"
local CustomeTextureManager = require "photomood.customtexture"
local likeapp = require "likeapp"
local Object = require "classic"



local MaskSequence = MaskSequenceBase:extend();


function MaskSequence:new(customID,channel,materialname,material_list,track_list,maincamera,videowidth,videoheight,renderorder)
  MaskSequence.super.new(self,customID,channel,materialname,material_list,track_list,maincamera,videowidth,videoheight,renderorder);
  
  --CustomeTextureManager:RegisterChangeCustomTextureCallback(self);
end


function MaskSequence:SetCustomTexture(texture,size)
  self.needRecreateFilter = false;
  if texture ~= nil then
    if size == nil then
       ERROR("custom_texture_size is nil");
    end
    if (self.custom_texture_size ~= size) then
      self.needRecreateFilter = true;  --需要重新挂载后处理队列
      ERROR("Old Custom Texture Size is: " .. tostring(self.custom_texture_size));
      ERROR("New Custom Texture Size is: " .. tostring(custom_texture_size));
    end
    self.custom_texture = texture;
    self.custom_texture_size = size;
  end
end


function MaskSequence:Update(timespan)
  
  if self.maskID == nil then
    ERROR("Mask id is nil! Maybe the rect file load failed!");
    likeapp.AI:OnCallback(0,"Mask id is nil! Maybe the rect file load failed!");
    return;
  end
  
  --得到帧号
  local frameIndex = self:GetFrameIndex();
  --得到custom 纹理
  if frameIndex == nil then
    ERROR("The frame index is null");
    likeapp.AI:OnCallback(0,"The frame index is null");
    return;
  end
  
  local needRecreateFilter = false;
  local custom_texture, custom_texture_size = CustomeTextureManager:GetCustomTexture(self.maskID);

  if custom_texture ~= nil then
    if custom_texture_size == nil then
       ERROR("custom_texture_size is nil");
    end
    if (self.custom_texture_size ~= custom_texture_size) then
      needRecreateFilter = true;  --需要重新挂载后处理队列
      ERROR("Old Custom Texture Size is: " .. tostring(self.custom_texture_size));
      ERROR("New Custom Texture Size is: " .. tostring(custom_texture_size));
    end
    self.custom_texture = custom_texture;
    self.custom_texture_size = custom_texture_size;
    self:SetShow(true); --开启绘制
  else
    self:SetShow(false); --关闭绘制
  end
  
  
  --Update
  MaskSequence.super.Update(self,frameIndex + 1,false); --最后一个参数指定是否需要重新创建挂载后处理
end

function MaskSequence:GetFrameIndex()
  return likeapp.AI:GetFrameIndex();
end

function MaskSequence:SetMaskTexture(texid,size)
  if self.maskID == nil then
    LOG("Internal mask id is nil");
  end

  if size and texid then
    local tex = apolloengine.TextureEntity();
    tex:PushMetadata(
      apolloengine.TextureResourceMetadata(
        mathfunction.vector2(size[1], size[2]),
        texid));
    tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
    tex:CreateResource();
    self.mask_texture = tex;
      --LOG("SetMaskTexture" .. tostring(id));
  else
    ERROR("empty size or texid");
  end
end


return MaskSequence;


