  
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local MaskRender = require "photomood.mask_render"
local LyricRender = require "photomood.lyric_render"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local biugodefined = require "photomood.defined"
local emptyimage = require "apolloutility.emptyimage"
local stringsplit = require "stringsplit"
local SquareInfo = require "photomood.squareinfo";
local Object = require "classic"
local likeapp = require "likeapp"





local LyricSequenceBase = Object:extend();


function LyricSequenceBase:new(inEffect,outEffect,outline_Color,outline_Offset)

  self.isShow = nil
  self.lyric_show_time = 0.0;
  self.lyric_acc_time = 0.0;
  self.progress_pre = 0.0;
  self.progress_post = 0.0;
  
  self.lyric_attributes_pre = inEffect.Attributes;
  self.lyric_duration_percent_pre = inEffect.DurationPercent;
  self.lyric_pre_start = 0;
  self.lyric_pre_end = 0;
  local durationType = type(self.lyric_duration_percent_pre);
  if durationType == "number" then
    self.lyric_pre_start = 0;
    self.lyric_pre_end = self.lyric_duration_percent_pre;
  else
    self.lyric_pre_start = self.lyric_duration_percent_pre[1];
    self.lyric_pre_end = self.lyric_duration_percent_pre[2];
  end
  
  self.lyric_attributes_post = outEffect.Attributes;
  self.lyric_duration_percent_post = outEffect.DurationPercent;
  self.lyric_post_start = 0;
  self.lyric_post_end = 0;
  local durationType = type(self.lyric_duration_percent_post);
  if durationType == "number" then
    self.lyric_post_start = 100 - self.lyric_duration_percent_post;
    self.lyric_post_end = 100;
  else
    self.lyric_post_start = self.lyric_duration_percent_post[1];
    self.lyric_post_end = self.lyric_duration_percent_post[2];
  end
  
  self.progress_pre = 0.0;
  self.progress_post = 0.0;

  local outlineColor = outline_Color;
  
  local lyricStrMaterial = self:AssemblyMaterial();
  local initSlots = self:AssemblyUniforms();
  
  self.lyricrender = LyricRender(lyricStrMaterial,initSlots,outlineColor,outline_Offset);

  self.enableLyric = true;
end

function LyricSequenceBase:ResetLyric()
  LOG("Reset Lyric");
  
  self.isShow = nil
  self.lyric_show_time = 0.0;
  self.lyric_acc_time = 0.0;
  self.progress_pre = 0.0;
  self.progress_post = 0.0;
  self.progress_pre = 0.0;
  self.progress_post = 0.0;
  --self.enableLyric = true;
  
end


function LyricSequenceBase:AssemblyAttrTween(attrName,stage,interpolate,startV,endV)
  local vertexPart = "";
  local fragmentPart = "";
  if attrName == "Position" then
    if string.find(interpolate,"In") or string.find(interpolate,"Out") then
      vertexPart = vertexPart .. "\"" .. attrName .. interpolate .. "\",\n";
    else
      vertexPart = vertexPart .. "\"" .. attrName .. interpolate .. stage .. "\",\n";
    end
    vertexPart = vertexPart .. "\"" .. attrName .. stage .. "\",\n";
  end
  if attrName == "Scale" then
    if string.find(interpolate,"In") or string.find(interpolate,"Out") then
      vertexPart = vertexPart .. "\"" .. attrName .. interpolate .. "\",\n";
    else
      vertexPart = vertexPart .. "\"" .. attrName .. interpolate .. stage .. "\",\n";
    end
    if startV[1] > endV[1] then
      vertexPart = vertexPart .. "\"" .. attrName .. "B2S" .. stage .. "\",\n";
    else
      vertexPart = vertexPart .. "\"" .. attrName .. "S2B" .. stage .. "\",\n";
    end
  end
  if attrName == "Alpha" then
    if string.find(interpolate,"In") or string.find(interpolate,"Out") then
      fragmentPart = fragmentPart .. "\"" .. attrName .. interpolate .. "\",\n";
    else
      fragmentPart = fragmentPart .. "\"" .. attrName .. interpolate .. stage .. "\",\n";
    end
    fragmentPart = fragmentPart .. "\"" .. attrName .. stage .. "\",\n";
  end
  if attrName == "Slice" then
    if string.find(interpolate,"In") or string.find(interpolate,"Out") then
      fragmentPart = fragmentPart .. "\"" .. attrName .. interpolate .. "\",\n";
    else
      fragmentPart = fragmentPart .. "\"" .. attrName .. interpolate .. stage .. "\",\n";
    end
    if startV[1] > endV[1] then
      fragmentPart = fragmentPart .. "\"" .. attrName .. "RTL" .. stage .. "\",\n";
    else
      fragmentPart = fragmentPart .. "\"" .. attrName .. "LTR" .. stage .. "\",\n";
    end
  end
  if attrName == "CutHorizontal" then
    if string.find(interpolate,"In") or string.find(interpolate,"Out") then
      fragmentPart = fragmentPart .. "\"" .. attrName .. interpolate .. "\",\n";
    else
      fragmentPart = fragmentPart .. "\"" .. attrName .. interpolate .. stage .. "\",\n";
    end
    if startV[1] > endV[1] then
      fragmentPart = fragmentPart .. "\"" .. attrName .. "B2T" .. stage .. "\",\n";
    else
      fragmentPart = fragmentPart .. "\"" .. attrName .. "T2B" .. stage .. "\",\n";
    end
  end
  if attrName == "CutVertical" then
    if string.find(interpolate,"In") or string.find(interpolate,"Out") then
      fragmentPart = fragmentPart .. "\"" .. attrName .. interpolate .. "\",\n";
    else
      fragmentPart = fragmentPart .. "\"" .. attrName .. interpolate .. stage .. "\",\n";
    end
    if startV[1] > endV[1] then
      fragmentPart = fragmentPart .. "\"" .. attrName .. "B2T" .. stage .. "\",\n";
    else
      fragmentPart = fragmentPart .. "\"" .. attrName .. "T2B" .. stage .. "\",\n";
    end
  end
  return vertexPart,fragmentPart;
end

function LyricSequenceBase:AssemblyAttUniform(startVName, endVName, startValue,endValue,slots)
  local startVCnt = #startValue;
  local endVCnt = #endValue;
  if startVCnt == 1 then
    table.insert(slots,{startVName,mathfunction.vector1(startValue[1])});
    table.insert(slots,{endVName,mathfunction.vector1(endValue[1])});
  end
  if startVCnt == 2 then
    table.insert(slots,{startVName,mathfunction.vector2(startValue[1],startValue[2])});
    table.insert(slots,{endVName,mathfunction.vector2(endValue[1],endValue[2])});
  end
  if startVCnt == 3 then
    table.insert(slots,{startVName,mathfunction.vector3(startValue[1],startValue[2],startValue[3])});
    table.insert(slots,{endVName,mathfunction.vector3(endValue[1],endValue[2],endValue[3])});
  end
  return slots;
end

function LyricSequenceBase:AssemblyUniforms()
  local initUniformMap = {};
  
  local pre_attr_cnt = #self.lyric_attributes_pre;
  for i = 1, pre_attr_cnt do
    local attribute = self.lyric_attributes_pre[i];
    local startVName = attribute.Name .. "InStartV";
    local endVName = attribute.Name .. "InEndV";
    local startV = attribute.StartV;
    local endV = attribute.EndV;
    self:AssemblyAttUniform(startVName,endVName,startV,endV,initUniformMap);
  end
  
  local post_attr_cnt = #self.lyric_attributes_post;
  for i = 1, post_attr_cnt do
    local attribute = self.lyric_attributes_post[i];
    local startVName = attribute.Name .. "OutStartV";
    local endVName = attribute.Name .. "OutEndV";
    local startV = attribute.StartV;
    local endV = attribute.EndV;
    self:AssemblyAttUniform(startVName,endVName,startV,endV,initUniformMap);
  end
  return initUniformMap;
end


function LyricSequenceBase:AssemblyMaterial()
  
  local vertex_shader_part_begin = [[
     VERTEX_SHADER = 
      {
          "TweenVertex",
    ]]
  local vertex_shader_part_end = [[
          "TweenVertexOutput"
      }
    ]]
  local fragment_shader_part_begin = [[
        FRAGMENT_SHADER = 
        {
          "TweenFragment",
    ]];
  local fragment_shader_part_end = [[
          "TweenFragmentOutput"
        }
    ]]
  
  local pre_attr_cnt = #self.lyric_attributes_pre;
  vertex_shader_part_begin = vertex_shader_part_begin .. "\"" .. "InProgress" .. "\",\n";
  fragment_shader_part_begin = fragment_shader_part_begin .. "\"" .. "InProgress" .. "\",\n";
  for i = 1, pre_attr_cnt do
    local attribute = self.lyric_attributes_pre[i];
    local vertexTmp,fargmentTmp = self:AssemblyAttrTween(attribute.Name,"In",attribute.Interpolation, attribute.StartV, attribute.EndV);
    vertex_shader_part_begin = vertex_shader_part_begin .. vertexTmp;
    fragment_shader_part_begin = fragment_shader_part_begin .. fargmentTmp;
  end
  
  local post_attr_cnt = #self.lyric_attributes_post;
  vertex_shader_part_begin = vertex_shader_part_begin .. "\"" .. "OutProgress" .. "\",\n";
  fragment_shader_part_begin = fragment_shader_part_begin .. "\"" .. "OutProgress" .. "\",\n";
  for i = 1, post_attr_cnt do
    local attribute = self.lyric_attributes_post[i];
    local vertexTmp,fargmentTmp = self:AssemblyAttrTween(attribute.Name,"Out",attribute.Interpolation, attribute.StartV, attribute.EndV);
    vertex_shader_part_begin = vertex_shader_part_begin .. vertexTmp;
    fragment_shader_part_begin = fragment_shader_part_begin .. fargmentTmp;
  end
  
  local vertexShaderStr = vertex_shader_part_begin .. vertex_shader_part_end
  local fragmentShaderStr = fragment_shader_part_begin .. fragment_shader_part_end;
  
  local alphamode_str = biugodefined.AlphaMode["Blend"];
  local material_begin = string.format(biugodefined.material_begin, "OVERLAY", alphamode_str);
  local materialsrc = material_begin .. vertexShaderStr .. "\n" .. fragmentShaderStr;
  materialsrc = materialsrc .. biugodefined.material_end;
  return materialsrc;
end

function LyricSequenceBase:ClearLyric()

  self.lyric_show_time = 0;
end


function LyricSequenceBase:SetSequence(s)
  self.lyricrender:SetSequence(s);
end

function LyricSequenceBase:SetShow(isShow)
  if self.isShow ~= isShow and self.enableLyric == true then
    self.isShow = isShow;
    self.lyricrender:SetShow(isShow);
  end
end

--这里作为一个总开关
function LyricSequenceBase:ShowLyric(isShow)
  if isShow == false then  --关闭歌词显示需要立即关闭
    self:SetShow(isShow);
  end
  self.enableLyric = isShow;
end


function LyricSequenceBase:Update(timespan)

  if self.lyric_show_time > 0 then
    self.lyric_acc_time = self.lyric_acc_time + timespan;
    if self.lyric_acc_time >= self.lyric_show_time then
      self:SetShow(false);  --时间结束，隐藏
      self.lyric_acc_time = self.lyric_show_time;
      self.progress_pre = 1.0;
    end


    local lyric_pre_duration_time = self.lyric_show_time* ((self.lyric_pre_end - self.lyric_pre_start) / 100);
    local lyric_pre_start_time = self.lyric_pre_start / 100 * self.lyric_show_time;
    local lyric_pre_end_time = self.lyric_pre_end / 100 * self.lyric_show_time;
    if self.lyric_acc_time >= lyric_pre_start_time then
      if (self.lyric_acc_time + timespan) > lyric_pre_end_time then
        self.progress_pre = 1.0;
      else
        self.progress_pre = (self.lyric_acc_time - lyric_pre_start_time) / lyric_pre_duration_time;
      end
    end

    local lyric_post_duration_time = self.lyric_show_time * ((self.lyric_post_end - self.lyric_post_start) / 100);
    local lyric_post_start_time = self.lyric_post_start / 100 * self.lyric_show_time;
    local lyric_post_end_time = self.lyric_post_end / 100 * self.lyric_show_time;
    if self.lyric_acc_time >= lyric_post_start_time then
      if (self.lyric_acc_time + timespan) > lyric_post_end_time then
        self.progress_post = 1.0;
      else
        self.progress_post = (self.lyric_acc_time - lyric_post_start_time) / lyric_post_duration_time;
      end
    end

    self:SetShow(true); --每帧都setshow
    self.lyricrender:SetProgress(self.progress_pre,self.progress_post);
    self.lyricrender:Update(self.lyric_texture);

    --LOG("LyricSequenceBase:Update");
  else
    self:SetShow(false); --关闭显示
  end
end

return LyricSequenceBase;
