
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local filterqueue = require "apolloutility.filterqueue" 
local Cover = require "photomood.cover"

local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local likeapp = require "likeapp"
local Object = require "classic"



local CustomTexture = {}

function CustomTexture:Initialize()
  self.customtexture_map = {};
  self.customtexture_size = {};
  self.isNew = true;
  
  --纹理大小改变
  self.newtexturesize_callback = {}
  setmetatable(self.newtexturesize_callback, {__mode = "v"}) 
  
  --更改纹理
  self.newtexturecallback = {}
  setmetatable(self.newtexturecallback, {__mode = "v"})
end

function CustomTexture:Clear()
  self.customtexture_map = {};
  self.customtexture_size = {};
end

function CustomTexture:RegisterChangeCustomTextureCallback(obj)
  table.insert(self.newtexturecallback,obj);
end

function CustomTexture:RegisterChangeCustomTextureSizeCallback(obj)
  table.insert(self.newtexturesize_callback,obj)
end



function CustomTexture:GetCustomTexture(id)
  local isCustomTextureChanged = likeapp.AI:IsCustomTextureChanged(id);
  
  if self.isNew == true or isCustomTextureChanged == true then
    local ts = likeapp.AI:GetCustomTexture(id);
    if ts then
      local custom_texture = apolloengine.TextureEntity();
      custom_texture:PushMetadata(
      apolloengine.TextureBufferMetadata(
          apolloengine.TextureEntity.TU_STATIC,
          1, false,
          apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
          apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
          apolloengine.TextureEntity.TF_LINEAR,
          apolloengine.TextureEntity.TF_LINEAR,
          ts));
      custom_texture:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
      custom_texture:CreateResource();
      self.customtexture_map[id] = custom_texture;  --保存用户纹理
      
      local customtexture_size = ts:GetSize();
      if self.customtexture_size[id] == nil or  self.customtexture_size[id] ~= customtexture_size then
        LOG("ResetCustomFilter");
        --filterqueue:ResetCustomFilter(ts:GetSize()); 
        Cover:Update(customtexture_size);  --新加载的资源或者图片大小变了更新一次
      end
      self.customtexture_size[id] =  ts:GetSize();  --保存用户纹理大小
      self.isNew = false;
    else
      ERROR("Custom texture is null");
    end
  end
  for _, obj in ipairs(self.newtexturecallback) do
    obj:OnChangeCustomTexture(self.customtexture_map[id])
  end
  return self.customtexture_map[id],self.customtexture_size[id];
end



return CustomTexture;



