  
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local photomooddef = require "photomood.defined"
local Object = require "classic"
local photomooddefined = require "photomood.defined"
local CustomTextureBlit = require "photomood.customtexture_blit"
local likeapp = require "likeapp"





local Cover = {};

function Cover:Initialize(maincamera,videowidth,videoheight)
  
  self.video_width = videowidth;
  self.video_height = videoheight;
  
  apolloengine.ShaderEntity.VERTEX_SCALER = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"VERTEX_SCALER");
  self.isShow = nil;
  local near = maincamera:GetNear();
  local far = maincamera:GetFar();
  local pos = maincamera:GetWorldPosition();
  local lookat = pos + maincamera:GetForward();
  local up = maincamera:GetUp();
  local color = mathfunction.vector4(0.0,0.0,0.0,0.0); --清屏颜色
    
  --在绘制一个最上面层的遮罩层
  self.cover_camera = apollonode.CameraNode();
  self.cover_camera:Activate();
  self.cover_camera:CreateRealCameraProjection(near, far);
  self.cover_camera:LookAt(pos, lookat, up);
  self.cover_camera:SetSequence(photomooddefined.photomood_mask_clip_camera_sequence -1);
  self.cover_rt = apolloengine.RenderTargetEntity();
  self.cover_rt:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      mathfunction.vector4(1.0,1.0,1.0,1.0),--清屏颜色
      mathfunction.vector4(0.0,0.0,videowidth,videoheight),
      mathfunction.vector2(videowidth,videoheight)));--分辨率
  self.cover_tex = self.cover_rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.cover_tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector2(videowidth,videoheight)));
  self.cover_rt:CreateResource();
  self.cover_camera:AttachRenderTarget(self.cover_rt);
  
  
    
  self.cover_blit = apollonode.QuadNode();
  self.cover_blit:SetShow(false);
  self.cover_blit:SetSequence(photomooddefined.photomood_mask_clip_camera_sequence - 1);
  self.cover_blit:CreateResource(photomooddefined.cover_background_material_path,true);
  self.cover_blit:SetParameter(apolloengine.ShaderEntity.VERTEX_SCALER,mathfunction.vector2(1.0,1.0));
  
  
  self.cover_clip = apollonode.QuadNode();
  self.cover_clip:SetShow(false);
  self.cover_clip:SetSequence(photomooddefined.photomood_mask_clip_camera_sequence - 1);
  self.cover_clip:CreateResource(photomooddefined.cover_before_material_path,true);
  
  self.quadnode = apollonode.QuadNode();
  self.quadnode:SetShow(false); 
  self.quadnode:CreateResource(photomooddefined.cover_material_path,true);
  self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.cover_tex);

end

function Cover:Clear()
  if self.cover_camera ~= nil then
    self.cover_camera:Deactivate();
    self.cover_camera = nil;
    self.cover_blit:SetShow(false);
    self.cover_blit = nil;
    self.cover_clip:SetShow(false);
    self.cover_clip = nil;
    self.quadnode:SetShow(false); 
    self.quadnode = nil;
  end
end



function Cover:SetSequence(s)
    self.quadnode:SetSequence(s);
end

function Cover:SetShow(isShow)
  if self.isShow ~= isShow then
    self.isShow = isShow;
     self.cover_clip:SetShow(isShow);
    self.cover_blit:SetShow(isShow);
    self.quadnode:SetShow(isShow);
  end
end


function Cover:Update(custom_texture_size)
  
  local rect_size = mathfunction.vector2(self.video_width,self.video_height);
  --用于裁剪缩放用户图片的顶点
  local vertexScaler = mathfunction.vector2(1.0,1.0);
  if custom_texture_size ~= nil then
    local custom_texture_width = custom_texture_size:x();
    local custom_texture_height = custom_texture_size:y();
    local rect_width = rect_size:x();
    local rect_height = rect_size:y();
    local rectRatio = rect_width / rect_height;
    local textureRatio = custom_texture_width / custom_texture_height;
    
    if textureRatio > rectRatio then
      vertexScaler:Set(1.0,rectRatio / textureRatio);
    elseif textureRatio < rectRatio then
      vertexScaler:Set(textureRatio / rectRatio,1.0);
    else
      vertexScaler:Set(1.0,1.0);
    end
  end

  self.cover_blit:SetParameter(apolloengine.ShaderEntity.VERTEX_SCALER,mathfunction.vector2(1.0,1.0));
  self.cover_clip:SetParameter(apolloengine.ShaderEntity.VERTEX_SCALER,vertexScaler);
  --self:SetShow(false);  --始终显示
end



return Cover;
