
local _DEBUG = true;
local GestureAnimation = require "gesturemagic.gestureanimation"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
require "venusdebug"
require "utility"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
--local modelnode = require "apolloutility.apollonode.modelnode"
local apollonode = require "apolloutility.apollonode"
local pbrlighting = require "apolloutility.pbrlighting"


local main = {}

function main:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;
  
  self.cumtime = self.cumtime + def;
  self.fps = self.fps + 1;
  
  if self.cumtime > 5 then
    local fps = self.fps / self.cumtime;
    self.fps = 0;
    self.cumtime = 0;
    LOG("FPS "..fps);
  end
  return def;
end


function main:CreateCameras(near, far, pos, lookat, up)  
  self.maincamera = apollonode.CameraNode();--新建摄像机
	self.maincamera:CreatePerspectiveProjection(near, far);--设置摄像机
	self.maincamera:LookAt(pos, lookat, up);
  self.maincamera:Activate();--激活主摄像机
  
  self.rendertarget = apolloengine.RenderTargetEntity();--创建一个FBO
  self.rendertarget:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_A,--标记作用，主要用于底层资源共享
      mathfunction.vector4(0.5,0.5,0.5,1),--清屏颜色
      apolloengine.Framework:GetViewport(),--视口大小
      apolloengine.Framework:GetResolution()));--分辨率
  self.outputtexture = self.rendertarget:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  self.outputtexture:PushMetadata(--创建纹理
				apolloengine.TextureBufferMetadata(apolloengine.Framework:GetResolution()));
  self.rendertarget:CreateResource();
  
    --创建一个渲染到rt的摄像机
  self.outputcamera = apollonode.CameraNode();
	self.outputcamera:CreatePerspectiveProjection(near, far);
	self.outputcamera:LookAt(pos, lookat, up);
  self.outputcamera:AttachRenderTarget(self.rendertarget);
  --self.outputcamera:EraseLayerMask(apolloengine.LayerMask.MC_MASK_DEFAULT_LAYER);--设置渲染mask
  self.outputcamera:SetSequence(
    self.maincamera:GetSequence() + 1);--将渲染摄像机的顺序设置为主摄像机之后渲染
  self.texturestream = apolloengine.TextureStream();
end

function main:Initialize()
  _COROUTINES_ON();
  self.ambient = apollonode.LightNode(apolloengine.LightComponent.LT_AMBIENT);
  self.ambient:SetColor(
    mathfunction.vector3(0.3,0.3,0.3));
  
  self.direct = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
  self.direct:SetColor(
    mathfunction.vector3(1,1,1));
  self.direct:SetLocalDirection(
    mathfunction.vector3(0,-1,-1));
  
  pbrlighting:Initialize();--对PBR材质中的贴图的slot进行初始化
  --对整个场景的cubemap进行声明
  apolloengine.ShaderEntity.SKY_BOX = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"SKY_BOX");
  local skybox = apolloengine.TextureEntity();
  skybox:PushMetadata(apolloengine.TextureFileMetadata("docs:skybox/front.jpg"));
  skybox:PushMetadata(apolloengine.TextureFileMetadata("docs:skybox/back.jpg"));
  skybox:PushMetadata(apolloengine.TextureFileMetadata("docs:skybox/top.jpg"));
  skybox:PushMetadata(apolloengine.TextureFileMetadata("docs:skybox/bottom.jpg"));
  skybox:PushMetadata(apolloengine.TextureFileMetadata("docs:skybox/left.jpg"));
  skybox:PushMetadata(apolloengine.TextureFileMetadata("docs:skybox/right.jpg"));
  skybox:CreateResource();
  apolloengine.IMaterialSystem:SetGlobalParameter(apolloengine.ShaderEntity.SKY_BOX,skybox);
  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.cumtime = 0;
  self.fps = 0;
  
  self:CreateCameras(1, 1000,
    mathfunction.vector3(0,0,1),
		mathfunction.vector3(0,0,0),
		mathfunction.vector3(0,1,0));
  
  self.rotation = mathfunction.Quaternion();
  self.model = apollonode.ModelNode();
  self.model:CreateResource("docs:toukui");
  self.model:SetLoop(true);
  self.model:Play();
  
  --self.model2 = apollonode.ModelNode();
  --self.model2:CreateResource("docs:Starry bear");
  --self.model2:SetLocalPosition(mathfunction.vector3(0,-0.5,0));
  --self.model2:SetLoop(true);
  --self.model2:Play();
  
  apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "Update");
  

  LOG("initialize done");
  _COROUTINES_OFF();
  return true;
end

function main:Update()
  local def = self:Timespan();
  self.model:UpdateAnimation(def);
  
  self.rotation = self.rotation * mathfunction.Mathutility:RotateAxis(
    mathfunction.vector3(0,1,0), math.pi / 4 * def);
  self.model:SetLocalRotation(self.rotation);

end

function main:Ontime()
  _COROUTINES_ON();
  self.gestureanimation:Update();
  _COROUTINES_OFF();
end

function main:OnTouch(touchinfo)
  _COROUTINES_ON();
  local vec2 = touchinfo:GetTouchPoint(1);
  self.gestureanimation:SetSimulateActionPoint(vec2);
  _COROUTINES_OFF();
  
end

function main:Abort()
  venuscore.ITimerSystem:UnregisterTimer(self._Agent, "Ontime");
  apolloengine.Framework:RemoveTouchCallback(self._Agent, "OnTouch");
  apolloengine.Framework:RemoveSynchronizeUpdateCallback(self._Agent, "Update");
  venuscore.IApplication:Abort();
end


return main;