require "venusdebug"
local venusjson = require "venusjson"
local venuscore = require "venuscore"
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
require "utility"

local nefelivfx = {}

function nefelivfx:Initialize(cameraLayer)
  self.filter = nil;
  self.maincamera = renderqueue:GetCamera(cameraLayer);
end

function nefelivfx:_SplitConfig(rootconfig) 
  self.scriptfile = rootconfig.script;
  self.config = rootconfig.config;
end

function nefelivfx:_GetFileDir(path)
  return string.match(path, "(.+)/[^/]*%.%w+$");
end

function nefelivfx:_GetFileName(path)
  return string.match(path, "[^/]+$");
end

function nefelivfx:LoadConfig(path)

  local fileDir = self:_GetFileDir(path);
  -- nefelivfx path  
  local rootdir = fileDir.."/";   
  local rootconfig = venusjson.LaodJsonFile(path);

  if rootconfig == nil then
    LOG("nefelivfx:LoadConfig failed 1")
    return false
  end

  if rootconfig.nefelivfx == nil then
    LOG("nefelivfx:LoadConfig failed 2")
    return false
  end

  self:_SplitConfig(rootconfig.nefelivfx);

  if(not self.scriptfile or not self.maincamera) then
    self.post = nil;
    LOG("nefelivfx:LoadConfig failed 3")
    return false;
  end

  venuscore.IFileSystem:SetResourcePath(rootdir);

  local scriptpath = self.scriptfile;
  local func,errorstr = loadfile(venuscore.IFileSystem:PathAssembly(scriptpath));
  if not errorstr then
    local filter = func();
    filter:Initialize(self.maincamera, self.config);
    self.filter = filter;
  else
    LOG("nefelivfx:LoadConfig failed 4")
    return false
  end
  return true;
end 

function nefelivfx:Update(def)
  if self.filter then
    self.filter:Update(def);
  end
end

function nefelivfx:ReleaseResource()
  if self.filter then
    self.filter:Exit();
    self.filter = nil;
  end
end

function nefelivfx:SetShow(show)
  if self.filter then
    self.filter:SetShow(show)
  end
end

return nefelivfx;
