local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local math = require "math"
local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local filterqueue = require "apolloutility.filterqueue"
local defined = require "apolloutility.defiend"
local splicehistoricalframe = require "historicalframe.splicehistoricalframe"
local videodetect = require "videodecet"
local displacemain={};

local Stored_Frame_Size = mathfunction.vector2(90, 160);
local Stored_Frame_Num = 120;
local Frequency = 1;
local Sequence = -4000;
local Inteval = 0.1;
local Direction = -1.0;
local Total_Period = 3000.0;

local MAX_SUPPORT_TEX_NUM = 4;

function displacemain:Initialize(camera, config)    
  if camera == nil then 
    return;
  end
  
  self.splice = splicehistoricalframe(camera,Stored_Frame_Num,Sequence, Frequency, defined.flip_material_path, Stored_Frame_Size); 
  self.maincamera = camera;
  self.config = config;

  self.post = apollonode.PostEffect();
  self.post:CreateResource("comm:script/apolloutility/posteffect/displace.lua");  
    
  local material_path = venuscore.IFileSystem:PathAssembly("comm:documents/material/displace.material");
  if not (self:SetShaderParameters(material_path, config)) then
    self:Clear();
    return;
  end  
  self.maincamera:AttachPostEffect(self.post);
end

function displacemain:Clear()
  self.post = nil;
  self.splice.Clear();
  self.splice = nil;  
end

function displacemain:CreateEmptyTexture()
  local texstream = apolloengine.TextureStream();
  texstream:SetStreamType(
    mathfunction.vector2(4,1),
    apolloengine.TextureEntity.PF_R8G8B8A8);
  
  for u=1, 4 do
    texstream:SetPixel(u, 1, mathfunction.vector4(0,0,0,0));
  end
  
  local tex = apolloengine.TextureEntity();
  tex:PushMetadata(apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_STATIC,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      texstream));
  tex:CreateResource();
  return tex;
end


function displacemain:SetShaderParameters(material_path, config)
  self.post:RegisterParameter("FRAME_SIZE", material_path);
  self.post:RegisterParameter("CUR_FRAME_ID", material_path);
  self.post:RegisterParameter("INTERVAL", material_path);
  self.post:RegisterParameter("DIRECTION", material_path);
  self.post:RegisterParameter("ROW_FRAME_NUM_PER_TEX", material_path);
  self.post:RegisterParameter("COL_FRAME_NUM_PER_TEX", material_path);
  self.post:RegisterParameter("TOTAL_PERIOD", material_path);
 
  if ( self.splice.bigtexnum  > MAX_SUPPORT_TEX_NUM) then
    return false;
  end
    
  for i = 1, MAX_SUPPORT_TEX_NUM do
    self.post:RegisterParameter("HISTORICAL_FRAME"..i, material_path);
  end

  self.post:FRAME_SIZE(mathfunction.vector1(self.splice.framNum));  
  self.post:CUR_FRAME_ID(mathfunction.vector1(0));
  
  local interval = config.interval or Interval;
  self.post:INTERVAL(mathfunction.vector1(interval));
  
  -- Json still use 0 or 1 to deduce whether do through x-direction or y-direciton
  -- while venus shader doesn't support pass int, so 0 convert to -1.0 instead to avoid potential  precision issue
  local direction = Direciton;
  if(config.direction ~= nil) then
    if(config.direction == 0) then
      direction = -1.0;
    else
      direction = 1.0;
    end
  end
  self.post:DIRECTION(mathfunction.vector1(direction));
  
  local total_period = config.total_time or Total_Period;
  self.post:TOTAL_PERIOD(mathfunction.vector1(total_period));
  
  local row_frames = self.splice.wcount;  
  self.post:ROW_FRAME_NUM_PER_TEX(mathfunction.vector1(row_frames));
  
  local col_frames = self.splice.hcount;
  self.post:COL_FRAME_NUM_PER_TEX(mathfunction.vector1(col_frames));  
  
  local tex = self:CreateEmptyTexture();
  for i = 1, MAX_SUPPORT_TEX_NUM do
    self.post["HISTORICAL_FRAME"..i](self.post, tex);
  end
  return true;
end

function displacemain:Update(def)
  if self.splice == nil then
    return;
  end
  
  local tex = videodetect:GetVideoTexture();
  if tex == nil then
    return;
  end
  
  self.splice:SetVideoTexture(tex);
  self.splice:SetShow(true);
  self.tex,self.newframe,self.isGetEnoughFrame= self.splice:Update();
  self.post:CUR_FRAME_ID(mathfunction.vector1(self.newframe - 1));
  for i = 1, #self.tex do
    self.post["HISTORICAL_FRAME"..i](self.post, self.tex[i]);
  end 
end

function displacemain:Exit()
  self.maincamera:DetachPostEffect(self.post);
  self:Clear();
end

function displacemain:SetShow(show)
  if self.post then
    if show then
      self.post:Enable()
    else
      self.post:Disable()
    end
  end
end

return displacemain;