local manipulatebase = require "lightgame.manipulatepartical.manipulatebase"
--local slowdown = require "lightgame.manipulatepartical.slowdown"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local detectdefined = require "videodecet.defined"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local videodecet = require "videodecet"
local define = require "lightgame.manipulatepartical.defined"



--操纵一个粒子，当信号出现的时候粒子减速直到停止
local slowdown_one_sound = manipulatebase:extend();

function slowdown_one_sound:new(path, trigger, acc, soundA)--acc时间减缓速度，单位百分比/每秒  
  slowdown_one_sound.super.new(self, trigger,soundA,soundA);
  self.timemul = 1;
  self.timespeed = acc;
  self.particleemitter = apollonode.ParticleNode();
  self.particleemitter:CreateResource(path);
  renderqueue:Before(self.particleemitter);
  self.isPlayDetectedSound = true;
  
  
end

 function slowdown_one_sound:_ResetParameter()
   --self.particleemitter:ResetParamMultipiler();
 end
 
function slowdown_one_sound:SetLocalPosition(pos)
  self.particleemitter:SetLocalPosition(pos);
end

function slowdown_one_sound:_SetTriggerdParam(paramName, value)
  self.particleemitter:SetParamMultipiler(paramName,value);
end

function slowdown_one_sound:_SetUnTriggerdParam(paramName, value)
  self.particleemitter:SetParamMultipiler(paramName,value);
end

function slowdown_one_sound:_OnDetected(def, globaloffset,globalscale)
  self.timemul = self.timemul - self.timespeed * def;
  self.timemul = self.timemul > 0 and self.timemul or 0;
  self.particleemitter:SetGlobalOffset(globaloffset);
  self.particleemitter:SetGlobalScale(globalscale);
  --if self.timemul > 0.01 then
  self.particleemitter:AsyncUpdate(self.timemul * def)
  --end
 
end

function slowdown_one_sound:_OnSilence(def)
  self.timemul = self.timemul + self.timespeed * def;
  self.timemul = self.timemul < 1 and self.timemul or 1;
  self.particleemitter:AsyncUpdate(self.timemul * def)

 
  self:PlaySound(2);  --一直播放A音效

end

function slowdown_one_sound:Exit()
  slowdown_one_sound.super:Exit();
end

return slowdown_one_sound;