local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local mathfunction = require "mathfunction"
local defined = require "apolloutility.defiend"
local haircolordefined = require "facecute.haircolor.haircolordefined"
local HistoricalFrameBase = require "apolloutility.basehistoricalframe"
require "utility"

local HistoricalFrameSplice = HistoricalFrameBase:extend();
HistoricalFrameSplice.sizewidth = 720;
HistoricalFrameSplice.sizeheight = 1280;

function HistoricalFrameSplice:new(maincamera,frameNum,sequence,interval,material,framesize,bigtexsize)
  
  if bigtexsize ~= nil then
    self.sizewidth = bigtexsize:x();
    self.sizeheight = bigtexsize:y();
  end
  
  --if self.sizewidth/sizex ~= self.sizeheight/sizey then
    --ERROR("historical frame not match");
    --return;
  --end
  
  HistoricalFrameSplice.super.new(self,maincamera,frameNum,sequence,material,framesize);
  self.numpertex = self.sizewidth/framesize:x() * self.sizeheight/framesize:y(); --每张纹理历史帧个数
  self.bigtexnum = math.ceil(frameNum/self.numpertex); --需要几张大纹理
  self.wcount = self.sizewidth/framesize:x(); --每张纹理历史帧列
  self.hcount = self.sizeheight/framesize:y(); --每张纹理历史帧行
  self.interval = interval;
  self.intervalcount = 0;
  self.framNum = frameNum;--总历史帧个数
  self.sequence = sequence;
  self.material = material;
  self.newframe = self.framNum;
  self.isquadshow = true;
  
  self.quadqueue = {};
  self.cameraqueue = {};
  self.splicertqueue = {};
  self.splicetexqueue = {};
  
  local near = maincamera:GetNear();
  local far = maincamera:GetFar();
  local pos = maincamera:GetWorldPosition();
  local lookat = pos + maincamera:GetForward();
  local up = maincamera:GetUp();
  local color = mathfunction.vector4(1.0,0.0,0.0,1.0); --清屏颜色
  
  for i=1,self.bigtexnum,1 do
    local splice_camera = apollonode.CameraNode(mathfunction.vector2(self.sizewidth,self.sizeheight));
    splice_camera:Activate();
    splice_camera:CreateRealCameraProjection(near, far);
    splice_camera:LookAt(pos, lookat, up);
    splice_camera:SetSequence(sequence+i);
    splice_camera:SetClearFlag(0);
    table.insert(self.cameraqueue,splice_camera);
    
    local rt = splice_camera:CreateRenderTarget();
    rt:PushMetadata(--设置FBO格式
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        color,--清屏颜色
        mathfunction.vector4(0,0,self.sizewidth,self.sizeheight),
        mathfunction.vector2(self.sizewidth,self.sizeheight)));--分辨率
    table.insert(self.splicertqueue, rt);
    
    local tex = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
    tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector2(self.sizewidth,self.sizeheight)));
    table.insert(self.splicetexqueue, tex);
    
    --rt:SetClearFlag(0);
    rt:CreateResource();
    splice_camera:AttachRenderTarget(rt);
    
    self:CreateTexture();
  end
  
end

function HistoricalFrameSplice:Update()
  self.intervalcount = self.intervalcount + 1;
  if self.intervalcount == self.interval then
    HistoricalFrameSplice.super.Update(self);
    self.intervalcount = 0;
  end
  
  self:UpdateTexture();
  
  
  --[[if self.isGetEnoughFrame == true then
    if self.quadqueue[1] == nil then 
      self:CreateTexture();
    else
      if self.isquadshow == true then
        for i=1,self.framNum,1 do
          self.quadqueue[i]:SetShow(false);
        end
        self.isquadshow = false;
      end
      self:UpdateTexture();
    end
  end]]--
  
  return self.splicetexqueue,self.newframe,self.isGetEnoughFrame;
end

function HistoricalFrameSplice:CreateTexture()
  for n=1,self.bigtexnum,1 do
    for i=0,self.hcount-1,1 do
      for j =0,self.wcount-1,1 do
        local vertexstream = apolloengine.VertexStream();--创建顶点流
        vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
          apolloengine.VertexBufferEntity.DT_FLOAT,
          apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
          4);
        vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		      apolloengine.VertexBufferEntity.DT_FLOAT,
		      apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		      2);
        vertexstream:ReserveBuffer(4); 
        local indexstream = apolloengine.IndicesStream(); 
        indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
        indexstream:ReserveBuffer(6);
    
        indexstream:PushIndicesData(0);
        indexstream:PushIndicesData(1);
        indexstream:PushIndicesData(2);
        indexstream:PushIndicesData(2);
        indexstream:PushIndicesData(1);
        indexstream:PushIndicesData(3);
        vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(-1+j*(2/self.wcount),1-i*(2/self.hcount),0,1.0));
        vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(-1+j*(2/self.wcount),1-(i+1)*(2/self.hcount),0,1.0));
        vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(-1+(j+1)*(2/self.wcount),1-i*(2/self.hcount),0,1.0));
        vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(-1+(j+1)*(2/self.wcount),1-(i+1)*(2/self.hcount),0,1.0));
        vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 1));
        vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 0));
        vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 1));
        vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 0));
  
        local quadnode = apollonode.QuadNode();
        quadnode:SetShow(false);
        quadnode:CreateResourceSpecific(defined.blit_material_path, vertexstream, indexstream);
        quadnode:SetSequence(self.sequence+n);
    
        quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.texqueue[i*self.wcount+j+1]);
        table.insert(self.quadqueue,quadnode);
        
      end
    end
  end
end

function HistoricalFrameSplice:UpdateTexture()
  
  if self.newframe - 1 < 1 then
    self.quadqueue[self.framNum+self.newframe-1]:SetShow(false);
  else
    self.quadqueue[self.newframe-1]:SetShow(false);
  end
  
  self.newframe = self.newframe + 1;
  if self.newframe > self.framNum then
    self.newframe = 1;
  end
  self.quadqueue[self.newframe]:SetShow(true);
  self.quadqueue[self.newframe]:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.texqueue[1])  
  
end


function HistoricalFrameSplice:Clear()
  HistoricalFrameSplice.super.Clear(self);
  self.quadqueue = {};
  self.cameraqueue = {};
  self.splicertqueue = {};
  self.splicetexqueue = {};
  self.sizewidth = 720;
  self.sizeheight = 1280;
end


return HistoricalFrameSplice;
