local venusjson = require "venusjson"
local venuscore = require "venuscore"



local maxtimespan = 1 / 15
local filter = {}
--考虑存在多个滤镜的情况

--增加脚本路径
function filter:_AddScriptPath(pathDir)
  
  --local gamepath = venuscore.IFileSystem:PathAssembly("root:lightgame");
  --gamepath = (gamepath.."/?.lua;")..(gamepath.."/?/?.lua;")..(gamepath.."/?/init.lua;");
  --gamepath ="E:/faceDeformationDev/master/algo_video_facecute/lightgame/sticker/..";
  --gamepath = (gamepath.."/?.lua;");
  self.originPackagePath = package.path;
  local gamepath=venuscore.IFileSystem:PathAssembly(pathDir);
  gamepath=gamepath.."/?.lua;";
  package.path =gamepath.. package.path;
end

--删除脚本路径
function filter:_RemoveScriptPath()  
  if self.originPackagePath then
    package.path = self.originPackagePath;
  end 
end

function filter:Initialize(maincamera)
  self.maincamera = maincamera;
  self.filtertable = {}
end

function filter:_SplitConfig(rootconfig) 
  self.filtername = rootconfig.filter.mainscript;
end

function filter:LoadConfig(path)
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig.filter then
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    self:_AddScriptPath(pathDir);
    self: _SplitConfig(rootconfig);  
    local rootdir = pathDir.."/"; 
    venuscore.IFileSystem:SetResourcePath(rootdir);
    local func,errorstr = loadfile(venuscore.IFileSystem:PathAssembly(rootdir..self.filtername));
    if not errorstr then
      local temp= func(); 
      temp:Initialize(self.maincamera,rootconfig);
      table.insert(self.filtertable,temp);
      return true;
    else  
      ERROR(errorstr);
      return false;
    end
  end
  return true;
end 

--考虑存在多个滤镜时的情况
function filter:Update(def)
  def = math.min(def, maxtimespan);
  for key,values in pairs(self.filtertable) do
     if values then
      values:Update(def);
     end
  end
end

function filter:OnRecordStart()
  for key,values in pairs(self.filtertable) do
     if values and values.OnRecordStart then
      values:OnRecordStart();
     end
  end
end

function filter:ReleaseResource()
  if next(self.filtertable) ~= nil then
    for key,values in pairs(self.filtertable) do
      if values then
        values:Exit();
      end    
    end
    self:_RemoveScriptPath();
    self.filtertable = {};
  end
end

return filter;