local sticker2drect = require "facecute.facesticker2d.sticker2drect"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"
local renderqueue = require "apolloutility.renderqueue"
local sticker2ddefine = require "facecute.facesticker2d.sticker2ddefine"
--local sticker2drectback = require "facecute.facesticker2d.sticker2drectback"
--管理多个facesticker2d
local facesticker2d = Object:extend();

function facesticker2d:new(maincamera)
  self.maincamera = maincamera;
  self.facesticker2ds = {};
  self.facesticker2dnames={};
end

--传入数据表，解析数据生成face组件
function facesticker2d:ParseConfig(config,para)

  if(config==nil)
  then
      return false;
  end
  
  

  local version = config["version"];
  local res = true;
  local configParts = config["parts"];
  local compress_root = config["compress_root"];
  local len = #configParts;
  local index =1;
  local stickerPara={para[1]};
  stickerPara[3] = tonumber(version);
    for name, defconfig in pairs(configParts) do

        --if(name~="test" and name~="CHy") 
       -- if(defconfig["enable"]==true and name~="CHy")
        if(defconfig["enable"]==true)
        then
           -- local b1 = sticker2drectback(self.maincamera);
           --renderqueue:After(b1);
           -- b1:ParseConfig(defconfig,stickerPara);
           -- table.insert(self.facesticker2ds,b1);
           local b = sticker2drect(self.maincamera);
           if defconfig.positionType == sticker2ddefine.positionType.Background then
            renderqueue:Before(b);
           else             
            renderqueue:After(b);
          end          
           --renderqueue:Queue(index,b);
           stickerPara[2]=name;
           res = res and b:ParseConfig(defconfig,stickerPara, compress_root);
           --local zPos = defconfig["zPosition"];
           --self.facesticker2ds[zPos+1] = b;
           table.insert(self.facesticker2ds,b);
           table.insert(self.facesticker2dnames,name);
        end
    end
    return res;
end

function facesticker2d:getAsset(name)
  
  local len = table.getn(self.facesticker2dnames);
  for i=1,len do
    if(name==self.facesticker2dnames[i])
    then
       return self.facesticker2ds[i];
    end
  end
  return nil;
end
function facesticker2d:SetShow(isshow)
  for _, def in ipairs(self.facesticker2ds) do
    def:SetShow(isshow);
    --if(isshow==false)
    --then
     -- def:Disappear();
   -- end
    
  end
end

function facesticker2d:OnFaceShow(b)
  for _, def in ipairs(self.facesticker2ds) do
    def:OnFaceShow(b);
  end
end

function facesticker2d:Update(timespan,face,position, rotation,action)
  for _, def in ipairs(self.facesticker2ds) do
    def:Update(timespan,face,position, rotation,action);
  end
end

function facesticker2d:SetRootNode(node)
  for _, def in ipairs(self.facesticker2ds) do
    node:AttachNode(def);
  end
end
return facesticker2d;