local sticker2ddefine = require "facecute.facesticker2d.sticker2ddefine"
--local posture = require "facecute.estimates.headposture";
local posture = require "facecute.estimates.transposture";
--local posture = require "facecute.estimates.pnpposture";
local apollonode = require "apolloutility.apollonode"
local headtarget =  require "facecute.headtarget";
local immortal =  require "facecute.immortal";
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local venusjson = require "venusjson"
local bitop = require "bit"
local cutebehavior = require "facecute.behavior.cutebehavior"
local facedefined = require "facecute.facechange.facedefined"
local faceinfo = require "videodecet.faceinfo"
local cnnseg= require "videodecet.cnnseg"
local likeapp = require "likeapp"
local videodefined = require "videodecet.defined"
local faceseg = require "videodecet.faceseg"
local hairtarget = require "facecute.haircolor.hairrendertarget"
--入口文件，解析配置表，调用和组装变形、3d、2d等功能
local facecute = {}




--初始化系统，传递主摄像机
function facecute:Initialize(maincamera)
  
  
  self.maincamera = maincamera;
  --初始化人头姿态估计
  posture:Initialize(maincamera);
  --创建常驻资源
  self.immortal = immortal(self.maincamera);
  --人头目标数组
  self.headtargets = {}
  for i = 1, defined.max_head_target_count do
    local ht = headtarget(self.maincamera);
    ht.headIndex = i;
    table.insert(self.headtargets, ht);
  end
  self.maxHeadCount = defined.max_head_target_count
  cutebehavior:Initialize();
  hairtarget:Initialize(maincamera);
  faceseg:RegisterAllSeg();
end

function facecute:OnResizeView(w,h)
  posture:OnResizeView(w,h)
  --[[if(cnnseg)
  then
   cnnseg:OnResizeView(w,h);
  end]]
  faceseg:OnResizeView(w,h);
end


--加载配置表生成数据
function facecute:_LoadVersion_1(rootconfig, paramters)
  local deforamtionfile = rootconfig["deformationFileName"];
   local deformationconfig = nil;
  if(deforamtionfile~=nil)
  then
     deformationconfig= venusjson.LaodJsonFile(paramters[1].."/"..deforamtionfile);
  end
  for i = 1, self.maxHeadCount do
    local ht = self.headtargets[i]
    ht:ParseConfig(rootconfig, paramters);
    if deformationconfig ~= nil then
      ht:ParseConfig(deformationconfig, paramters);
    end
  end
end

function facecute:_LoadVersion_3(rootconfig, paramters)
  local deforamtionfile = rootconfig["deformationFileName"];
  local deformationconfig = venusjson.LaodJsonFile(paramters[1].."/"..deforamtionfile);
  local tdconfig = rootconfig["parts3d"];
  for i = 1, self.maxHeadCount do
    local ht = self.headtargets[i]
    ht:ParseConfig(rootconfig, paramters);
    ht:ParseConfig(deformationconfig, paramters);
  end
end

--分割配置表
function facecute:_SplitConfig(rootconfig)  
  local fbconfig = {};
  if nil ~= rootconfig.parts then
    for key, value in pairs(rootconfig.parts) do
      if value.positionType == sticker2ddefine.positionType.ForgeGround
        or value.positionType == sticker2ddefine.positionType.Background then
          fbconfig.parts = fbconfig.parts or {};
          fbconfig.parts[key] = value;
          rootconfig.parts[key] = nil;
      end        
    end  
  end  
  if nil ~= rootconfig.soundParts then
    for key, value in pairs(rootconfig.soundParts) do
      if value.triggerType == 0 then
        fbconfig.soundParts = fbconfig.soundParts or {};        
        fbconfig.soundParts[key] = value;
        rootconfig.soundParts[key] = nil;
      end      
    end    
  end  
  fbconfig.compress_root = rootconfig.compress_root;
  fbconfig.version = rootconfig.version;
  fbconfig.stickerType = rootconfig.stickerType;
  return rootconfig, fbconfig
end

--处理trigger，得出当前动作，遇到需要背景分割的，将分割位置去掉
function facecute:_ProcesssActions(rootconfig)  
  local actions = {}
  if(videodecet.SetCnnSegMark)
  then
    videodecet:SetCnnSegMark(false);
  end
  faceseg:SetSegMark(videodefined.faceSegType.CNNSEG_FULL,false);  
  faceseg:SetSegMark(videodefined.faceSegType.CNNSEG_FULL_HAIR,false);
  if(likeapp.AI.ActiveCnnseg)
  then
    likeapp.AI:ActiveCnnseg(false);
  end
  local function _ite(config)
    for key, value in pairs(config) do
      if type(value) == "table" then
        _ite(value);
      elseif key == "triggerType" and value ~= 0 then
        if bitop.band( value, defined.background_segment_flag ) ~= 0 then
          value = value - defined.background_segment_flag;
          config[key] = value;
          if(videodecet.SetCnnSegMark)
          then
              videodecet:SetCnnSegMark(true);
          end
          faceseg:SetSegMark(videodefined.faceSegType.CNNSEG_FULL,true);
          if(likeapp.AI.ActiveCnnseg)
          then
            likeapp.AI:ActiveCnnseg(true);
          end
        end        
        actions[value] = true;
      end      
    end    
  end
  _ite(rootconfig);
  self.activeactions = actions;
  local actionarray = {}
  for key,_ in pairs(actions) do
    table.insert(actionarray, key)
  end
  videodecet:ActiveActions(actionarray);
end



local function stripextension(filename)
	local idx = filename:match(".+()%.%w+$")
	if(idx) then
		return filename:sub(1, idx-1)
	else
		return filename
	end
end



function facecute:LoadConfig(path)
  local res = true;
  local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
  local rootconfig = venusjson.LaodJsonFile(path);
  self:_ProcesssActions(rootconfig);
  local rootconfig, fbconfig = self:_SplitConfig(rootconfig);
  local paramters = {pathDir,tonumber(rootconfig["version"])};
  local maxHeadCount = rootconfig["maxHeadCount"]
  if maxHeadCount ~= nil then
    self.maxHeadCount = math.min(maxHeadCount, self.maxHeadCount);
  end
  if rootconfig.deformationFileName then
    local defpath = pathDir..'/'..rootconfig.deformationFileName;
    local deformationconfig = venusjson.LaodJsonFile(defpath);
    for i = 1, #self.headtargets do
      local ht = self.headtargets[i]
      res = res and ht:ParseConfig(deformationconfig, paramters);
    end
  end  
  
  res = res and self.immortal:ParseConfig(fbconfig, paramters);
  self.immortal:SetShow(true);
  
  if(rootconfig.parts3d and rootconfig.parts3d.metaScenePath)
  then
    local filename = string.match(path, ".+/([^/]*%.%w+)$");
    filename = stripextension(filename);
    local metascenepath = pathDir..'/'..rootconfig.parts3d.metaScenePath..'/'..filename..".metascene";
    local metasceneconfig = venusjson.LaodJsonFile(metascenepath);
    paramters["metascene"] = metasceneconfig;
  end

  for i = 1, #self.headtargets do
    local ht = self.headtargets[i]
    res = res and ht:ParseConfig(rootconfig, paramters);
  end
  
  if rootconfig.soundParts then
  end
  return res;
end

function facecute:GetNilFaceInfo()
  
    if(self.nilface)
    then
      return self.nilface;
    end
    local fo = faceinfo(facedefined.cavasSize);
    local faceTex = facedefined.faceTexPoints;
    local len =facedefined.facePointCount;
    local nilkeyPoints={};
    for i=1,len do
       table.insert( nilkeyPoints,{faceTex[2*i-1]/facedefined.cavasSize[1]-10,faceTex[2*i]/facedefined.cavasSize[2]-10});
      --table.insert( nilkeyPoints,{0,0});
    end
    fo:PushRotation(0,0,0,0);
    fo.rect={0,0,0,0};
    fo:UpdateKeypoints(nilkeyPoints);
    self.nilface = fo
    return fo;
    
end
function facecute:ReleaseResource()
  self.immortal:ReleaseResource();
  hairtarget:Clear();
  for _, ht in ipairs(self.headtargets) do
    ht:ReleaseResource();
  end
  self.maxHeadCount = defined.max_head_target_count
end

function facecute:_ActiveActionCount(actions)
  local count = 0;
  for _, pepole in ipairs(actions) do
    for _, action in ipairs(pepole) do
      local id = action:GetActionID();
      if self.activeactions[id] then
        count = count + 1;
        break;
      end      
    end    
  end  
  return count;
end

local emptyaction = {}
local defpos = mathfunction.vector3(0,0,-0.5);
local defrot = mathfunction.Quaternion();
local definfpos = mathfunction.vector3(-100000000,-100000000,-100000000);

function facecute:Update(timespan,maincamera)
  local faces = videodecet:GetFaces();
  local actions = videodecet:GetActions();--返回当前识别出来的动作
  if faces then
    posture:Update(faces,maincamera);
    local postures = posture:GetPostures();
    local actioncount = self:_ActiveActionCount(actions);
    local showcount = math.max(#postures, actioncount);
    showcount = math.min(showcount, self.maxHeadCount)
    
   --hairtarget:SetShow(showcount ~= 0);
    
    --先隐藏不要的
    for i = showcount + 1, #self.headtargets do
      local hn = self.headtargets[i]
      hn:SetShow(false);
    end
    
    --再修改需要的
    if 0 == #postures then
      --如果没有人头我们就默认更新
      local nilface = self:GetNilFaceInfo();
      self.immortal:Update(timespan, nilface, nil,nil, actions[1] or emptyaction);
      for i = 1, showcount do
        local hn = self.headtargets[i];
        if hn then
          hn:SetShow(true);
          hn:Update(timespan, nilface, definfpos, defrot, actions[i]);
        end        
      end
    else
      for index, est in ipairs(postures) do
        if index <= showcount then
          if 1 == index then
            --如果有人头我们就按照第一个人的数据更新
            self.immortal:Update(timespan, faces[index], est.position, est.rotation, actions[index]);
          end
          local hn = self.headtargets[index];
          if hn then
            hn:SetShow(true);
            hn:Update(timespan, faces[index], est.position, est.rotation, actions[index]);
          end
        end
      end
      
    end  
  end
  for i = 1, self.maxHeadCount do
    local ht = self.headtargets[i]
    ht:FixUpdate();
  end  
end


return facecute;
