local videodecet = require "videodecet"
local mathfunction = require "mathfunction"

--类功能，通过关键点计算和估计人头姿态信息
local headposture = {}

--初始化
function headposture:Initialize(camera)
  self.camera = camera;
  self.postureestimates = {}
	--[[
  --下列插入测试数据，真实数据需要在update中计算
  local head1 = {
    position = mathfunction.vector3(0,0,-1),
    rotation = mathfunction.Quaternion()
  }
  table.insert(self.postureestimates, head1);
  local head2 = {
    position = mathfunction.vector3(0.2,0,-1),
    rotation = mathfunction.Quaternion()
  }
  table.insert(self.postureestimates, head2);
	]]--
end

function headposture:GetPostures()
  return self.postureestimates;
end

--根据传入的faceinfo数组来计算人脸model的空间坐标
--模型鼻尖的空间坐标为vec3(0,0.02159,0.06191)
--模型左眼的空间坐标为vec3(-0.03048,0.04651,0.0267)
--模型右眼的空间坐标为vec3(0.03048,0.04651,0.0267)
function headposture:Update(faces,maincamera)

	self.postureestimates = {}
	for i=1,#faces do

		--根据识别出的yaw ritch roll三个方向上的旋转度数 得到头部模型的旋转四元数
		local quat = mathfunction.Mathutility:YawPitchRoll(-math.rad(faces[i]:GetRotation()[3]),math.rad(faces[i]:GetRotation()[1]),math.rad(faces[i]:GetRotation()[2]))
		--LOG(("rotation[%d]  x:%.3f y: %.3f z: %.3f"):format(i,-math.rad(faces[i]:GetRotation()[3]),math.rad(faces[i]:GetRotation()[1]),math.rad(faces[i]:GetRotation()[2])))

		--根据旋转四元数以及识别出来的左右眼位置，得到旋转之前的左右眼的距离
		local left_eye = faces[i]:GetKeypoint(74)
		local right_eye = faces[i]:GetKeypoint(77)
		local eye_length = mathfunction.vector2(left_eye[1]- right_eye[1], left_eye[2]- right_eye[2]):Length()
		-- 得到模型中的点先旋转，然后位移，最后透视在视角中的距离
		local origin_left_eye = mathfunction.vector4(-0.03048, 0.04651, -0.0267, 1.0) * quat --* translate * maincamera:GetViewProj()
		local origin_right_eye = mathfunction.vector4(0.03048, 0.04651, -0.0267, 1.0) * quat --* translate * maincamera:GetViewProj()
		origin_left_eye = (origin_left_eye + mathfunction.vector4(0, 0, -1, 0)) * maincamera:GetViewProj()
		origin_right_eye = (origin_right_eye + mathfunction.vector4(0, 0, -1, 0)) * maincamera:GetViewProj()
		origin_left_eye = mathfunction.vector4(origin_left_eye:x()/origin_left_eye:w(),origin_left_eye:y()/origin_left_eye:w(),origin_left_eye:z()/origin_left_eye:w(),1.0)
		origin_right_eye = mathfunction.vector4(origin_right_eye:x()/origin_right_eye:w(),origin_right_eye:y()/origin_right_eye:w(),origin_right_eye:z()/origin_right_eye:w(),1.0)
		local origin_eye_length = mathfunction.vector2(origin_left_eye:x()- origin_right_eye:x(),origin_left_eye:y()- origin_right_eye:y()):Length()
		origin_eye_length = 0.03048 * 2.0 * eye_length  / origin_eye_length

		--向左眼和右眼分别射线，求射线最近的距离
		local left_eye_r = maincamera:PickRay(mathfunction.vector2(left_eye[1],left_eye[2]));
		local left_eye_origin = mathfunction.Ray.GetOrigin(left_eye_r);
		local left_eye_deriction = mathfunction.Ray.GetDirection(left_eye_r);
		local left_offset = mathfunction.vector4(-0.03048, 0.04651, 0.0267, 1.0) * quat

		local right_eye_r = maincamera:PickRay(mathfunction.vector2(right_eye[1],right_eye[2]));
		local right_eye_origin = mathfunction.Ray.GetOrigin(right_eye_r);
		local right_eye_deriction = mathfunction.Ray.GetDirection(right_eye_r);
		local right_offset = mathfunction.vector4(0.03048, 0.04651, 0.0267, 1.0) * quat

		local vertical = left_eye_deriction:Cross(right_eye_deriction)


    --根据识别的鼻尖位置，得到头部模型的位置
		local face_pos =  mathfunction.vector4(faces[i]:GetKeypoint(46)[1], faces[i]:GetKeypoint(46)[2], 1.0, 1.0)
		--LOG(("faca[%d] pos x:%.3f y: %.3f"):format(i,face_pos:x(),face_pos:y()))
		local r = maincamera:PickRay(mathfunction.vector2(face_pos:x(),face_pos:y()));
		local origin = mathfunction.Ray.GetOrigin(r);
		local deriction = mathfunction.Ray.GetDirection(r);
		--LOG(("camera_origin: [x: %.3f y: %.3f z: %.3f ] "):format(origin:x(),origin:y(),origin:z()))
		--LOG(("camera_deriction: [x: %.3f y: %.3f z: %.3f ] "):format(deriction:x(),deriction:y(),deriction:z()))
		local head_offset =  mathfunction.vector4(0, 0.02159, 0.06191, 1.0) * quat
		local newpos = origin + deriction * (0.0 +  0.03048 * 2.0/origin_eye_length) -  mathfunction.vector3(head_offset:x(), head_offset:y(), head_offset:z())
		--LOG(("origin_eye_length[%d] : %.6f real_length : %.2f"):format(i,origin_eye_length,(-1.0 + 0.03048 * 2.0/origin_eye_length)))
		--LOG(("newpos: [x: %.3f y: %.3f z: %.3f ] "):format(newpos:x(),newpos:y(),newpos:z()))

		local head1 = {
	    position = mathfunction.vector3(newpos:x(),newpos:y(),newpos:z()),
	    rotation = quat
	  }
	  table.insert(self.postureestimates, head1);
	end
end

return headposture;
