local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local renderqueue = require "apolloutility.renderqueue"
local b3 = require "behavior3"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
local behdefined = require "facecute.behavior.behdefined"
local transfer = apollonode.CircleNode:extend();
local cutebehavior = require "facecute.behavior.cutebehavior"
--transfer变形器
function transfer:new(maincamera)
	self.maincamera = maincamera;
  transfer.super.new(self);
  transfer.super.SetShow(self, false);
  self.curTime = 0;
  self.initMark = 0;
  self.curLoop = self.initMark ;
  self.frames =0;
  self.events={};
  self.curFrame= 0;
  self.stateType = behdefined.stateType.NULL;
end

--像素：标准单位 = 0.00028755
local function ModelLengthToWorldLength(le)
	local val = le*0.00028755
	return val
end

function transfer:SetShow(isshow)  
  if (self.triggerType==nil or 0 == self.triggerType)
  then
    transfer.super.SetShow(self,isshow);
    if(isshow==false)
    then
      self:ReStart();
    end
  else
     if(isshow==false)
     then
       --if(self:IsOnFace())
       --then
         transfer.super.SetShow(self,false);
         self:ReStart();
       --end
     end
  end
end

function transfer:ReStart()
  self.curTime = 0;
  self.initMark = -10000
  self.curLoop = self.initMark ;
  self.curFrame= 0;
  self.stateType = behdefined.stateType.NULL;
  self.disAction = nil;
  self.lastAction = nil;
  self.action = nil;
end

--人头原点像素位置为：vec2(385,700)
function transfer:ParseConfig(config,para)
  --解析配置表，读取数据，设置初始状态
	local radius = ModelLengthToWorldLength(config["deformSize"][1])*0.5
	self.centeroffset = mathfunction.vector2(radius*config["centerOffset"][1],-radius*config["centerOffset"][2]);
	self.position = mathfunction.vector3(ModelLengthToWorldLength(config["originRef"]["position"][1]-385)+radius,ModelLengthToWorldLength(700-config["originRef"]["position"][2])-radius,0.05);
	self:SetLocalPosition(self.position);

  self:CreateResource(
    self.centeroffset,
    radius,
    defined.cricle_point_count,
    defined.transfer_material_path);--材质名称 路径
   self.layerOrder = para["layerOrder"];
   
  self:SetTrigger(config);
  self.version =  para["version"];
end
function transfer:SetVisible(vis)
    transfer.super.SetShow(self,vis);
end

function transfer:SetTrigger(config)
  self.triggerType = config["triggerType"];
  self.triggerLoop = config["displayFrames"];
  self.triggerDelay = config["triggerDelay"];
  if(self.triggerDelay~=nil)
  then
    self.triggerDelay = self.triggerDelay;
  end
  
  self.triggerStop = config["triggerStop"];
end
function transfer:Render()
  
  local timespan = self.timespan;
  local videotexture = videodecet:GetVideoTexture();
  local tex = renderqueue:_GetTexture(self.layerOrder-1);
  self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, tex);
	--self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, videotexture);
end

function transfer:GetLoopCount()
  return self.frames;
end

function transfer:ResetLoopCount()
    self.frames = 0;
end

function transfer:Update(timespan, face, position, rotation, action)
   self.timespan = timespan;
   self.frames = self.frames+1;
   self.action = action;
   self.curFrame= self.curFrame+1;
   self:ResetEvent();
   cutebehavior:tick(self);
end

function transfer:GetLoopFrameCount()
  return self.curFrame;
end

function transfer:AddEvent(event)
  table.insert(self.events,event)
end

function transfer:ResetEvent()
  self.events ={};
end


function transfer:ResetLoopFrameCount()
  self.curFrame = 0;
end
function transfer:GetLoopCount()
  return self.curFrame;
end

function transfer:ResetLoopCount()
    self.curFrame = 0;
end

function transfer:Play()
  self:SetVisible(true);
  self:Render();
end

return transfer;
