local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local renderqueue = require "apolloutility.renderqueue"
local facedefined = require "facecute.facechange.facedefined"
local b3 = require "behavior3"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
local behdefined = require "facecute.behavior.behdefined"
local cutebehavior = require "facecute.behavior.cutebehavior"
local defordefined = require "facecute.deformation.defordefined"
--贝塞尔变形器
local bezier = apollonode.CircleNode:extend();

function bezier:new(maincamera)
  self.maincamera = maincamera;
  bezier.super.new(self);
  bezier.super.SetShow(self, false);
  apolloengine.ShaderEntity.TEXTURE_BEZIER =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BEZIER");
  apolloengine.ShaderEntity.UNIFORM_CENTERPOS =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_CENTERPOS");
  apolloengine.ShaderEntity.UNIFORM_NEW_CENTERPOS =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_NEW_CENTERPOS");

  apolloengine.ShaderEntity.UNIFORM_RATIOASPECT =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
     "UNIFORM_RATIOASPECT");
   
  local depth={};
  for i=1,106 do
    depth[i] = 0.05;
  end

  for i=1,6 do
    depth[i]=-0.05;
  end
  
    for i=7,16 do
    depth[i]=-0.05+(i-7+1)/100;
  end
  
  for i=26,32 do
    depth[i]=-0.05;
  end
  
  for i=17,25 do
    depth[i]=0.05-1*(i-17+1)/90.0;
  end
  
  for i=33,37 do
    depth[i]= 0.058;
  end
  
  for i=64,67 do
    depth[i]= 0.058;
  end
  
  for i=38,42 do
    depth[i]= 0.058;
  end
  
  for i=68,71 do
    depth[i]= 0.058;
  end
  depth[0]=-0.05;
  self.depth ={};
  for i=1,106 do
   self.depth[i]=depth[i-1]; 
  end
  
  self.depth[46] = 0.0633;
  self.depth[45] = 0.05665;
  self.depth[47] = 0.0633;
  self.depth[59] =0.05;
  self.depth[53] =0.02;
  self.depth[62] =0.02;

  self.curTime = 0;
  self.initMark = 0;
  self.curLoop = self.initMark ;
  self.frames = 0;
  self.events ={};
  self.curFrame = 0;
  self.stateType = behdefined.stateType.NULL;
  self.needupd= false;
  self.curLen = nil;

end


function bezier:InitKalman()
  --[[ self.lastpx = 0.2;
   self.lastpy = 0.2;
   self.edgasx = 0.1;
   self.eogasx = 0.9;
   self.edgasy =0.1;
   self.eogasy = 0.9;
   self.lastRatiox = 0.9;
   self.lastRatioy = 0.9;]]
   self.lastpx     = defordefined.kalmanX.initOptP;
   self.lastpy     = defordefined.kalmanY.initOptP;
   self.edgasx     = defordefined.kalmanX.predictionStd;
   self.eogasx     = defordefined.kalmanX.ObservationStd;
   self.edgasy     = defordefined.kalmanY.predictionStd;
   self.eogasy     = defordefined.kalmanY.ObservationStd;
   self.lastRatiox = defordefined.kalmanX.initValue;
   self.lastRatioy = defordefined.kalmanY.initValue;
end

function bezier:SetTrigger(config)
  self.triggerType = config["triggerType"];
  self.triggerLoop = config["displayFrames"];
  self.triggerDelay = config["triggerDelay"];
  if(self.triggerDelay~=nil)
  then
    self.triggerDelay = self.triggerDelay;
  end
  self.triggerStop = config["triggerStop"];
end

--像素：标准单位 = 0.00028755
local function ModelLengthToWorldLength(le)
	local val = le*0.00028755
	return val
end

local function WorldLengthToModelLength(le)
	local val = le/0.00028755
	return val
end

--人头原点像素位置为：vec2(385,700)
function bezier:ParseConfig(config,para)
  --解析配置表，读取数据，设置初始状态
  local pos={}
  pos[1] = config["originRef"]["position"][1];
  pos[2] = config["originRef"]["position"][2];
  local radius = config["deformSize"][1]*0.5;
  pos[1]=pos[1]+radius;
  pos[2]=pos[2]+radius;

  local posOffset={};
  
  posOffset[1]=-(facedefined.faceCenter[1]-pos[1]);
  posOffset[2]=facedefined.faceCenter[2]-pos[2];
  
  local indices = config["originRef"]["indices"];
  local depth = 0;
  local indicesLen = table.getn(indices);
  self.refIndex={};
  for i=1,indicesLen do
    self.refIndex[i] = indices[i]+1;
    depth = depth+ self.depth[indices[i]+1];
  end
  
  depth = depth/indicesLen;
  
  
	--local radius = ModelLengthToWorldLength(config["deformSize"][1])*0.5
	--self.centeroffset = mathfunction.vector2(radius*config["centerOffset"][1],-radius*config["centerOffset"][2]);
	--self.position = --mathfunction.vector3(ModelLengthToWorldLength(config["originRef"]["position"][1]-385)+radius,ModelLengthToWorldLength(700-config["originRef"]["position"][2])-radius--,0.05);
--	self:SetLocalPosition(self.position);
  
  local radiusWorld = ModelLengthToWorldLength(radius)*self:GetCircleModCof();
  self.centeroffset = mathfunction.vector2(radiusWorld*config["centerOffset"][1],-radiusWorld*config["centerOffset"][2]);
  self.position = mathfunction.vector3(ModelLengthToWorldLength(posOffset[1]),ModelLengthToWorldLength(posOffset[2]),depth);
  self:SetLocalPosition(self.position);

   local centerModelPos = {self.position:x(),self.position:y()};  --ref point 49
   local centerModelOffset ={self.centeroffset:x(),self.centeroffset:y()};--ref circle center
   self.centerModelOffset = self.centeroffset;

   --self:SetLocalPosition(mathfunction.vector3(centerModelPos[1],centerModelPos[2],0.05));
    self.ts = apolloengine.TextureStream();
    self.ts:SetStreamType(
    	mathfunction.vector2(256,1),
    	apolloengine.TextureEntity.PF_L8);
    local aBZTable = config["radialTable"]
    for u=1, 256 do
      for v=1,1 do
         self.ts:SetPixel(u, v, mathfunction.vector1(aBZTable[u]*255));
      end
    end    
  self.render:PushMetadata(
    apolloengine.RenderObjectTextureMetadata(
      apolloengine.ShaderEntity.TEXTURE_BEZIER,
      apolloengine.TextureBufferMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_LINEAR,
        apolloengine.TextureEntity.TF_LINEAR,
        self.ts)));
  
  self:CreateResource(
    self.centerModelOffset,
    radiusWorld,
    defined.cricle_point_count,
    defined.bezier_material_path);
  self.layerOrder = para["layerOrder"];
  self:SetTrigger(config);
  self.version =  para["version"];
  self:CalcRatio();
  self:InitKalman();
end

function bezier:IsNeedUpdatRatio()
  local needz = false;
  local faceContour = defordefined.faceContour;
  for j=1,#self.refIndex do
    needz = false;
    for i=1,#faceContour do
      if(faceContour[i]==self.refIndex[j])
      then
        needz = true;
      end
    end
    if(needz==false)
    then
      
      return false;
    end
  end
  return true;
end


--index start from 0 
function bezier:GetScreenPt(ptIndex)
  self:SetLocalPosition( mathfunction.vector3(0,0,0));
  local vp = self.maincamera:GetViewProj();
  local m = self:GetWorldTransform();
  local matrix = m*vp;
  local faceCenter = facedefined.faceCenter;
  local facePt={0,0};
  facePt[1] = facedefined.faceTexPoints[2*(ptIndex+1)-1]+facedefined.faceTexPointsOffset[1]-faceCenter[1];
  facePt[2] = (facedefined.faceTexPoints[2*(ptIndex+1)]+facedefined.faceTexPointsOffset[2]-faceCenter[2])*(-1);
  local screenpt = mathfunction.vector3(ModelLengthToWorldLength(facePt[1]),ModelLengthToWorldLength(facePt[2]),self.depth[ptIndex+1])*matrix;
  return screenpt;
  
end


--vector pt1pt2
function bezier:GetKeyPointVector(pt1,pt2)
  return {pt2[1]-pt1[1],pt2[2]-pt1[2]};
end

function bezier:GetVector2dLength(vec)
  return math.sqrt(vec:x()*vec:x()+vec:y()*vec:y());
end

function bezier:GetKeyPointLength(pt)
   return math.sqrt(pt[1]*pt[1]+pt[2]*pt[2]);
end

function bezier:GetCircleModCof()
  if(not self:IsFaceContour())
  then
    return defordefined.zoomCircleMod[1];
  end
  return defordefined.zoomCircleMod[2];
end

function bezier:IsFaceContour()
  local needz = false;
  local faceContour = defordefined.faceContour;
  for j=1,# self.refIndex do
    needz = false;
    for i=1,#faceContour do
      if(faceContour[i]==self.refIndex[j])
      then
        needz = true;
      end
    end
    if(needz==false)
    then
      
      return false;
    end
  end
  return true;
end


function bezier:UpDateRatio()
  
  if(not self:IsNeedUpdatRatio())
  then
     self.ratio  = defordefined.zoom["normal"];
     self.ratiox = defordefined.zoom["normal"];
     self.ratioy = defordefined.zoom["normal"];
     return;
  end
  local r = self.face:GetRotation();
  local rlen = math.sqrt(math.pow(r[1],2)+math.pow(r[2],2)+math.pow(r[3],2));
  if(self.curLen~=nil)
  then
     if(self.curLen<rlen or self.curLen==rlen)
     then
        return;
      end
  end
  
  if(rlen<defordefined.updateAngleLen)
  then
    self.needupd = true;
    self.curLen = rlen;
  end
   
  if(self.needupd ==false )
  then
    return;
  end
  local ratiox,ratioy = self:CalculRatio();
  self:CalculateKalman(ratiox,ratioy);
  --LOG(self.ratiox)
  --LOG(self.ratioy)
  self.needupd = false;

end

function bezier:CalculRatio()
  
  local refOrgIndex =defordefined.refOrgIndex;
  local v31 = self:GetScreenPt(refOrgIndex);
  local refIndex={};
  for i=1,#self.refIndex do
    refIndex[i] = self.refIndex[i]-1;
  end
 
  local v32pt={0,0};
  local indexLen = #self.refIndex;
  for i=1 ,indexLen do
    local pt = self:GetScreenPt(self.refIndex[i]-1);
    v32pt[1]=v32pt[1]+pt:x();
    v32pt[2]=v32pt[2]+pt:y();
  end
  v32pt[1]=v32pt[1]/indexLen;
  v32pt[2]=v32pt[2]/indexLen;
  local v32 = mathfunction.vector3(v32pt[1],v32pt[2],0);
  
  --local Keypoints = self.face:GetKeypointArray();
  --local v31d=Keypoints[refOrgIndex+1];
  --local v31dv=mathfunction.vector3(v31d[1],v31d[2],0);
  local vector1 = v32 - v31;
  --local vector1 = v32 - v31dv;
  local length1 = self:GetVector2dLength(vector1);
  local Keypoints = self.face:GetKeypointArray();
  local v31d=Keypoints[refOrgIndex+1];
  local v32d={0,0};
  for i=1,#self.refIndex do
    v32d[1]=v32d[1]+Keypoints[self.refIndex[i]][1];
    v32d[2]=v32d[2]+Keypoints[self.refIndex[i]][2];
  end
  v32d[1]=v32d[1]/#self.refIndex;
  v32d[2]=v32d[2]/#self.refIndex;
  local vectord1 =self:GetKeyPointVector(v31d,v32d);
  local lengthd1 = self:GetKeyPointLength(vectord1);
  local ratio = math.sqrt(length1*length1)/math.sqrt(lengthd1*lengthd1);
  self.ratio = ratio;
  local ratiox,ratioy;
  ratiox = math.sqrt(math.pow((vector1:x()),2))/math.sqrt(math.pow((vectord1[1]),2));
  ratioy = math.sqrt(math.pow((vector1:y()),2))/math.sqrt(math.pow((vectord1[2]),2));
  
  return ratiox,ratioy;
  
end


function bezier:CalculateKalman(ratiox,ratioy)
  
  self.edx = math.sqrt(math.pow(self.lastpx,2)+math.pow(self.edgasx,2));
  self.eox = self.eogasx;
  self.kgx = math.pow(self.edx,2)/(math.pow(self.edx,2)+math.pow(self.eox,2));
  self.ratiox = self.lastRatiox+self.kgx*(ratiox-self.lastRatiox);
  self.lastpx = math.sqrt((1-self.kgx)*math.pow(self.edx,2));
  
  self.edy = math.sqrt(math.pow(self.lastpy,2)+math.pow(self.edgasy,2));
  self.eoy = self.eogasy;
  self.kgy = math.pow(self.edy,2)/(math.pow(self.edy,2)+math.pow(self.eoy,2));
  self.ratioy = self.lastRatioy+self.kgy*(ratioy-self.lastRatioy);
  self.lastpy = math.sqrt((1-self.kgy)*math.pow(self.edy,2));
  self.lastRatiox = self.ratiox;
  self.lastRatioy = self.ratioy;
  
end

function bezier:GetCircleModCof()
  if(not self:IsFaceContour())
  then
    return defordefined.zoomCircleMod[1];
  end
  return defordefined.zoomCircleMod[2];
end

function bezier:IsFaceContour()
  local needz = false;
  local faceContour = defordefined.faceContour;
  for j=1,# self.refIndex do
    needz = false;
    for i=1,#faceContour do
      if(faceContour[i]==self.refIndex[j])
      then
        needz = true;
      end
    end
    if(needz==false)
    then
      
      return false;
    end
  end
  return true;
end


function bezier:CalcRatio()
  
  local needz = false;
  local faceContour = defordefined.faceContour;
  for j=1,# self.refIndex do
    needz = false;
    for i=1,#faceContour do
      if(faceContour[i]==self.refIndex[j])
      then
        needz = true;
      end
    end
    if(needz==false)
    then
       self.ratio  = defordefined.zoom["normal"];
       self.ratiox = defordefined.zoom["normal"];
       self.ratioy = defordefined.zoom["normal"];
      return;
    end
  end
  self.ratio =defordefined.zoom["x"];
  self.ratiox = defordefined.zoom["x"];
  self.ratioy = defordefined.zoom["y"];
end

function bezier:Render()
  --self:UpDateRatio();
  local    timespan = self.timespan;
  self:SetLocalPosition( mathfunction.vector3(self.position:x()*self.ratiox ,self.position:y()*self.ratioy ,self.position:z()));
  --self:SetLocalPosition( mathfunction.vector3(self.position:x(),self.position:y(),self.position:z()));
  local vp = self.maincamera:GetViewProj();
  local m = self:GetWorldTransform();
  local videotexture = videodecet:GetVideoTexture();
  local vec2 = apolloengine.Framework:GetResolution();
  if(videotexture==nil or vp==nil or m==nil or vec2==nil)
  then
    return;
  end
    
  local screencen = mathfunction.vector4(0,0,0,1) * m * vp;
  local screenoffset = mathfunction.vector4(self.centerModelOffset:x(),self.centerModelOffset:y(),0,1)* m * vp;
  local screencenvec2 = mathfunction.vector2(
      screencen:x() / screencen:w(),
      screencen:y() / screencen:w());
  local screenoffsetvec2 = mathfunction.vector2(
      screenoffset:x() / screenoffset:w(),
      screenoffset:y() / screenoffset:w());
   -- LOG(screenoffsetvec2);
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_RATIOASPECT, vec2);
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_CENTERPOS, screencenvec2);
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_NEW_CENTERPOS, screenoffsetvec2);
  -- self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, videotexture);
  local tex = renderqueue:_GetTexture(self.layerOrder-1);
  self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, tex);
 -- self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, videotexture);
end
function bezier:SetVisible(vis)
    bezier.super.SetShow(self,vis);
end

function bezier:SetShow(isshow)  
  if (self.triggerType==nil or 0 == self.triggerType)
  then
    bezier.super.SetShow(self,isshow);
    if(isshow==false)
    then
      self:ReStart();
    end
  else
     if(isshow==false)
     then
       --if(self:IsOnFace())
       --then
         bezier.super.SetShow(self,false);
         self:ReStart();
       --end
     end
  end
end

function bezier:ReStart()
  self.curTime = 0;
  self.initMark = 0;
  self.curLoop = self.initMark;
  self.stateType = behdefined.stateType.NULL;
  self.disAction = nil;
  self.lastAction = nil;
  self.action = nil;
  
  self.needupd = false;
  --self.updlimit = defordefined.limitupd;
  self.curLen = nil;
  self:CalcRatio();
  self:InitKalman();
end

function bezier:Update(timespan, face, position, rotation, action)
  self.timespan = timespan;
  self.frames = self.frames+1;
  self.action = action;
  self.face = face;
  self.curFrame= self.curFrame+1;
  self:ResetEvent();
  cutebehavior:tick(self);
end



function bezier:GetLoopFrameCount()
  return self.curFrame;
end

function bezier:AddEvent(event)
  table.insert(self.events,event)
end

function bezier:ResetEvent()
  self.events ={};
end


function bezier:ResetLoopFrameCount()
  self.curFrame = 0;
end
function bezier:GetLoopCount()
  return self.curFrame;
end

function bezier:ResetLoopCount()
    self.curFrame = 0;
end
function bezier:Play()
  self:SetVisible(true);
  self:Render();
end

return bezier;
